/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.indices;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndexKt;
import com.intellij.platform.ml.embeddings.search.indices.InMemoryEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.LocalEmbeddingIndexFileManager;
import com.intellij.platform.ml.embeddings.search.utils.ScoredText;
import com.intellij.util.containers.CollectionFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u001c0\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0011\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u001c\u0010(\u001a\u00020\u00192\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050*H\u0016J-\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00052\b\u00100\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u0019H\u0016J\b\u00104\u001a\u00020\u0019H\u0002J\b\u00105\u001a\u00020\u0019H\u0016J%\u00106\u001a\b\u0012\u0004\u0012\u00020-072\u0006\u0010.\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0002\u00108R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex;", "Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "root", "Ljava/nio/file/Path;", "limit", "", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "fileManager", "Lcom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager;", "idToEmbedding", "", "", "Lai/grazie/emb/FloatTextEmbedding;", "value", "getLimit", "()Ljava/lang/Integer;", "setLimit", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "size", "getSize", "()I", "addEntries", "", "values", "", "Lkotlin/Pair;", "checkAllIdsPresent", "", "ids", "", "checkCanAddEntry", "contains", "id", "estimateLimitByMemory", "memory", "", "estimateMemoryUsage", "filterIdsTo", "idToCount", "", "findClosest", "", "Lcom/intellij/platform/ml/embeddings/search/utils/ScoredText;", "searchEmbedding", "topK", "similarityThreshold", "", "(Lai/grazie/emb/FloatTextEmbedding;ILjava/lang/Double;)Ljava/util/List;", "loadFromDisk", "save", "saveToDisk", "streamFindClose", "Lkotlin/sequences/Sequence;", "(Lai/grazie/emb/FloatTextEmbedding;Ljava/lang/Double;)Lkotlin/sequences/Sequence;", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nInMemoryEmbeddingSearchIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1#2:87\n478#3,7:88\n1726#4,3:95\n*S KotlinDebug\n*F\n+ 1 InMemoryEmbeddingSearchIndex.kt\ncom/intellij/platform/ml/embeddings/search/indices/InMemoryEmbeddingSearchIndex\n*L\n64#1:88,7\n69#1:95,3\n*E\n"})
public final class InMemoryEmbeddingSearchIndex
implements EmbeddingSearchIndex {
    @NotNull
    private Map<String, FloatTextEmbedding> idToEmbedding;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final LocalEmbeddingIndexFileManager fileManager;
    @Nullable
    private Integer limit;

    public InMemoryEmbeddingSearchIndex(@NotNull Path root, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        this.idToEmbedding = map;
        this.lock = new ReentrantReadWriteLock();
        this.fileManager = new LocalEmbeddingIndexFileManager(root, 0, 2, null);
        this.limit = limit;
    }

    public /* synthetic */ InMemoryEmbeddingSearchIndex(Path path, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(path, n);
    }

    @Override
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimit(@Nullable Integer value) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (value != null && value < this.idToEmbedding.size()) {
                this.idToEmbedding = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)CollectionsKt.take((Iterable)MapsKt.toList(this.idToEmbedding), (int)value)));
            }
            this.limit = value;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.idToEmbedding.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NotNull String id) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.idToEmbedding.containsKey(id);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntries(@NotNull Iterable<Pair<String, FloatTextEmbedding>> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.getLimit() != null) {
                List list = CollectionsKt.toList(values);
                Iterable iterable = list;
                Integer n2 = this.getLimit();
                Intrinsics.checkNotNull((Object)n2);
                MapsKt.putAll(this.idToEmbedding, (Iterable)CollectionsKt.take((Iterable)iterable, (int)Math.min(n2 - this.idToEmbedding.size(), list.size())));
            } else {
                MapsKt.putAll(this.idToEmbedding, values);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToDisk() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            this.save();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromDisk() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Pair<List<String>, List<FloatTextEmbedding>> pair;
            boolean bl = false;
            if (this.fileManager.loadIndex() == null) {
                return;
            }
            Pair<List<String>, List<FloatTextEmbedding>> pair2 = pair;
            List ids = (List)pair2.component1();
            List embeddings = (List)pair2.component2();
            this.idToEmbedding = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)ids, (Iterable)embeddings)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ScoredText> findClosest(@NotNull FloatTextEmbedding searchEmbedding, int topK, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            List<ScoredText> list = EmbeddingSearchIndexKt.findClosest(this.idToEmbedding, searchEmbedding, topK, similarityThreshold);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Sequence<ScoredText> streamFindClose(@NotNull FloatTextEmbedding searchEmbedding, @Nullable Double similarityThreshold) {
        Intrinsics.checkNotNullParameter((Object)searchEmbedding, (String)"searchEmbedding");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Sequence<ScoredText> sequence2 = EmbeddingSearchIndexKt.streamFindClose((Sequence<Pair<String, FloatTextEmbedding>>)SequencesKt.map((Sequence)MapsKt.asSequence(this.idToEmbedding), (Function1)streamFindClose.1.1.INSTANCE), searchEmbedding, similarityThreshold);
            return sequence2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void filterIdsTo(@NotNull Map<String, Integer> idToCount) {
        Intrinsics.checkNotNullParameter(idToCount, (String)"idToCount");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            void $this$filterKeys$iv;
            boolean bl = false;
            int oldSize = this.idToEmbedding.size();
            Set<String> uniqueIds = idToCount.keySet();
            Map<String, FloatTextEmbedding> map = this.idToEmbedding;
            InMemoryEmbeddingSearchIndex inMemoryEmbeddingSearchIndex = this;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!uniqueIds.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            inMemoryEmbeddingSearchIndex.idToEmbedding = MapsKt.toMutableMap((Map)result$iv);
            if (this.idToEmbedding.size() != oldSize) {
                this.save();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAllIdsPresent(@NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl;
            block6: {
                boolean bl2 = false;
                Iterable $this$all$iv = ids;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (this.idToEmbedding.containsKey(it)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            boolean bl4 = bl || !this.checkCanAddEntry();
            return bl4;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public long estimateMemoryUsage() {
        return (long)this.fileManager.getEmbeddingSizeInBytes() * (long)this.getSize();
    }

    @Override
    public int estimateLimitByMemory(long memory) {
        return (int)(memory / (long)this.fileManager.getEmbeddingSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean checkCanAddEntry() {
        var1_1 = this.lock.readLock();
        var1_1.lock();
        try {
            $i$a$-read-InMemoryEmbeddingSearchIndex$checkCanAddEntry$1 = false;
            if (this.getLimit() == null) ** GOTO lbl-1000
            v0 = this.idToEmbedding.size();
            v1 = this.getLimit();
            Intrinsics.checkNotNull((Object)v1);
            if (v0 < v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            var3_4 = v2;
            return var3_4;
        }
        finally {
            var1_1.unlock();
        }
    }

    private final void save() {
        Pair pair = CollectionsKt.unzip((Iterable)MapsKt.toList(this.idToEmbedding));
        List ids = (List)pair.component1();
        List embeddings = (List)pair.component2();
        this.fileManager.saveIndex(ids, embeddings);
    }
}

