/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class FileUtils {
    private FileUtils() {
    }

    public static void saveStreamContentAsFile(String fullFileName, InputStream stream) throws IOException {
        fullFileName = FileUtils.findFreeFileName(fullFileName);
        try (FileOutputStream ostream = new FileOutputStream(fullFileName);){
            int read;
            byte[] buf = new byte[8192];
            while ((read = stream.read(buf, 0, buf.length)) != -1) {
                ((OutputStream)ostream).write(buf, 0, read);
            }
            ostream.flush();
        }
        new File(fullFileName);
    }

    private static String findFreeFileName(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return filename;
        }
        int dot2 = filename.lastIndexOf(46);
        String name = filename.substring(0, dot2);
        String ext = filename.substring(dot2);
        int num = 0;
        while ((f = new File(name + ++num + ext)).exists()) {
        }
        return name + num + ext;
    }
}

