/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.tools.FileUtils;
import com.intellij.xml.tools.GenerateInstanceDocumentFromSchemaDialog;
import com.intellij.xml.tools.Xsd2InstanceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class GenerateInstanceDocumentFromSchemaAction
extends AnAction {
    GenerateInstanceDocumentFromSchemaAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(0);
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = GenerateInstanceDocumentFromSchemaAction.isAcceptableFile(file);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GenerateInstanceDocumentFromSchemaDialog dialog2 = new GenerateInstanceDocumentFromSchemaDialog(project, file);
        dialog2.setOkAction(() -> GenerateInstanceDocumentFromSchemaAction.doAction(project, dialog2));
        dialog2.show();
    }

    public static void doAction(Project project, GenerateInstanceDocumentFromSchemaDialog dialog2) {
        String xml;
        String pathToUse;
        FileDocumentManager.getInstance().saveAllDocuments();
        @NonNls LinkedList<Object> parameters = new LinkedList<Object>();
        String url = dialog2.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(relativeFile);
        if (!(file instanceof XmlFile)) {
            Messages.showErrorDialog((Project)project, (String)(" (" + file.getFileType().getDescription() + ")"), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        if (!dialog2.enableRestrictionCheck()) {
            parameters.add("-nopvr");
        }
        if (!dialog2.enableUniquenessCheck()) {
            parameters.add("-noupa");
        }
        parameters.add("-dl");
        try {
            final File tempDir = FileUtil.createTempFile((String)"xsd2inst", (String)"");
            tempDir.delete();
            tempDir.mkdir();
            pathToUse = tempDir.getPath() + File.separatorChar + Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)file, new HashMap<String, String>(), new Xsd2InstanceUtils.SchemaReferenceProcessor(){

                @Override
                public void processSchema(String schemaFileName, byte[] schemaContent) {
                    try {
                        String fullFileName = tempDir.getPath() + File.separatorChar + schemaFileName;
                        FileUtils.saveStreamContentAsFile(fullFileName, new ByteArrayInputStream(schemaContent));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return;
        }
        parameters.add(pathToUse);
        parameters.add("-name");
        parameters.add(dialog2.getElementName());
        try {
            xml = Xsd2InstanceUtils.generate(ArrayUtilRt.toStringArray(parameters));
        }
        catch (Throwable e) {
            Messages.showErrorDialog((Project)project, (String)ExceptionUtil.getMessage((Throwable)e), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        String xmlFileName = relativeFileDir.getPath() + File.separatorChar + dialog2.getOutputFileName();
        try {
            File xmlFile = new File(xmlFileName);
            FileUtil.writeToFile((File)xmlFile, (String)xml);
            VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xmlFile));
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"could.not.save.generated.xml.document.0", (Object[])new Object[]{StringUtil.getMessage((Throwable)e)}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
    }

    static boolean isAcceptableFileForGenerateSchemaFromInstanceDocument(VirtualFile virtualFile) {
        return virtualFile != null && "xsd".equalsIgnoreCase(virtualFile.getExtension());
    }

    public static boolean isAcceptableFile(VirtualFile file) {
        return GenerateInstanceDocumentFromSchemaAction.isAcceptableFileForGenerateSchemaFromInstanceDocument(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/tools/GenerateInstanceDocumentFromSchemaAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/tools/GenerateInstanceDocumentFromSchemaAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

