/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.InlaysChangedListener;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellEditorScrollingPositionKeeper;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellEditorScrollingPositionKeeperKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellHighlighterRenderer;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookGutterLineMarkerManager;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.UpdateInlaysTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 O2\u00020\u0001:\u0002OPB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\u001e\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010%\u001a\u00020&H\u0002J6\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190,H\u0002J\u0018\u0010-\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0$2\u0006\u00100\u001a\u00020&H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u00100\u001a\u00020&H\u0002J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J\b\u00106\u001a\u00020\u001dH\u0002J\b\u00107\u001a\u00020\u001dH\u0002J\b\u00108\u001a\u00020\u001dH\u0002J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00120:2\u0006\u0010;\u001a\u00020\u0019J\b\u0010<\u001a\u00020\u001dH\u0002J\u0018\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0019H\u0002J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u000204H\u0002J\b\u0010A\u001a\u00020BH\u0002J\u0014\u0010C\u001a\u00020\u001d2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0 J\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020EJ\u0006\u0010G\u001a\u00020\u001dJ\u0006\u0010H\u001a\u00020\u001dJ\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020&H\u0002J\u001e\u0010K\u001a\u00020\u001d2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010M\u001a\u00020\u001d2\u0006\u00100\u001a\u00020&J\u001a\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00190$*\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00020\u000e*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006Q"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "changedListener", "Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;", "getChangedListener", "()Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;", "setChangedListener", "(Lorg/jetbrains/plugins/notebooks/visualization/InlaysChangedListener;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "initialized", "", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController;", "notebookCellLines", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "viewportQueue", "shouldHaveHighlighter", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "getShouldHaveHighlighter", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)Z", "addDocumentListener", "", "addHighlighters", "intervals", "", "addViewportChangeListener", "ensureInlaysAndHighlightersExist", "matchingCellsBeforeChange", "", "logicalLines", "Lkotlin/ranges/IntRange;", "failSafeCompute", "factory", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;", "controllers", "intervalIterator", "", "getInlays", "getMatchingHighlightersForLines", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "lines", "getMatchingInlaysForLines", "getMatchingInlaysForOffsets", "startOffset", "", "endOffset", "handleRefreshedDocument", "initialize", "inlaysChanged", "inlaysForInterval", "", "interval", "refreshHighlightersLookAndFeel", "rememberController", "controller", "saturateLine", "line", "textAttributesForHighlighter", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "update", "pointers", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "pointer", "updateAll", "updateAllImmediately", "updateConsequentInlays", "interestingRange", "updateControllers", "matchingCells", "updateImmediately", "getMatchingCells", "Companion", "NotebookCellDataProvider", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,455:1\n1549#2:456\n1620#2,3:457\n1222#2,4:461\n1620#2,3:465\n1271#2,2:468\n1285#2,4:470\n1603#2,9:475\n1855#2:484\n1856#2:486\n1612#2:487\n1#3:460\n1#3:485\n14#4:474\n14#4:489\n8#5:488\n10#5:490\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager\n*L\n191#1:456\n191#1:457,3\n211#1:461,4\n221#1:465,3\n228#1:468,2\n228#1:470,4\n324#1:475,9\n324#1:484\n324#1:486\n324#1:487\n324#1:485\n278#1:474\n288#1:489\n369#1:488\n383#1:490\n*E\n"})
public final class NotebookCellInlayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Map<Inlay<?>, NotebookCellInlayController> inlays;
    @NotNull
    private final NotebookCellLines notebookCellLines;
    @NotNull
    private final MergingUpdateQueue viewportQueue;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    private boolean initialized;
    @Nullable
    private InlaysChangedListener changedListener;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<NotebookCellInlayManager> key;

    private NotebookCellInlayManager(EditorImpl editor) {
        this.editor = editor;
        this.inlays = new HashMap();
        this.notebookCellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        this.viewportQueue = new MergingUpdateQueue("NotebookCellInlayManager Viewport Update", 100, true, null, this.editor.getDisposable(), null, true);
        this.updateQueue = new MergingUpdateQueue("NotebookCellInlayManager Interval Update", 20, true, null, this.editor.getDisposable(), null, true);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Nullable
    public final InlaysChangedListener getChangedListener() {
        return this.changedListener;
    }

    public final void setChangedListener(@Nullable InlaysChangedListener inlaysChangedListener) {
        this.changedListener = inlaysChangedListener;
    }

    @NotNull
    public final Iterable<NotebookCellInlayController> inlaysForInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.getMatchingInlaysForLines(interval.getLines());
    }

    public final void updateImmediately(@NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        if (this.initialized) {
            this.updateConsequentInlays(lines);
        }
    }

    public final void updateAllImmediately() {
        if (this.initialized) {
            this.updateQueue.cancelAllUpdates();
            this.updateConsequentInlays(new IntRange(0, this.editor.getDocument().getLineCount()));
        }
    }

    public final void updateAll() {
        this.updateQueue.queue((Update)new UpdateInlaysTask(this, null, true, 2, null));
    }

    public final void update(@NotNull Collection<? extends NotebookIntervalPointer> pointers) {
        Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
        this.updateQueue.queue((Update)new UpdateInlaysTask(this, pointers, false, 4, null));
    }

    public final void update(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this.updateQueue.queue((Update)new UpdateInlaysTask(this, (Collection)new SmartList((Object)pointer), false, 4, null));
    }

    private final void addViewportChangeListener() {
        this.editor.getScrollPane().getViewport().addChangeListener(arg_0 -> NotebookCellInlayManager.addViewportChangeListener$lambda$0(this, arg_0));
    }

    private final void initialize() {
        this.editor.putUserData(key, (Object)this);
        this.handleRefreshedDocument();
        this.addDocumentListener();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = this.editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> NotebookCellInlayManager.initialize$lambda$1(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> NotebookCellInlayManager.initialize$lambda$2(this, arg_0));
        this.addViewportChangeListener();
        this.initialized = true;
    }

    private final void refreshHighlightersLookAndFeel() {
        RangeHighlighter[] rangeHighlighterArray = this.editor.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        for (RangeHighlighter highlighter : rangeHighlighterArray) {
            if (highlighter.getCustomRenderer() != NotebookCellHighlighterRenderer.INSTANCE) continue;
            RangeHighlighterEx rangeHighlighterEx = highlighter instanceof RangeHighlighterEx ? (RangeHighlighterEx)highlighter : null;
            if (rangeHighlighterEx == null) continue;
            rangeHighlighterEx.setTextAttributes(this.textAttributesForHighlighter());
        }
    }

    private final void handleRefreshedDocument() {
        ThreadingAssertions.softAssertReadAccess();
        List factories = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        for (NotebookCellLines.Interval interval : this.notebookCellLines.getIntervals()) {
            for (NotebookCellInlayController.Factory factory : factories) {
                NotebookCellInlayController controller = this.failSafeCompute(factory, this.editor, CollectionsKt.emptyList(), this.notebookCellLines.getIntervals().listIterator(interval.getOrdinal()));
                if (controller == null) continue;
                this.rememberController(controller, interval);
            }
        }
        this.addHighlighters((Collection<NotebookCellLines.Interval>)this.notebookCellLines.getIntervals());
        this.inlaysChanged();
    }

    private final void addDocumentListener() {
        DocumentListener documentListener2 = new DocumentListener(this){
            @NotNull
            private List<NotebookCellLines.Interval> matchingCellsBeforeChange;
            private boolean isBulkModeEnabled;
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                this.matchingCellsBeforeChange = CollectionsKt.emptyList();
            }

            private final IntRange interestingLogicalLines(Document document, int startOffset, int length) {
                int end2 = startOffset + length <= document.getTextLength() ? document.getLineNumber(startOffset + length) : document.getLineCount() + 1;
                return new IntRange(document.getLineNumber(startOffset), end2);
            }

            public void bulkUpdateStarting(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.isBulkModeEnabled = true;
                this.matchingCellsBeforeChange = NotebookCellInlayManager.access$getMatchingCells(this.this$0, NotebookCellInlayManager.access$getNotebookCellLines$p(this.this$0), RangesKt.until((int)0, (int)document.getLineCount()));
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.isBulkModeEnabled) {
                    return;
                }
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                IntRange logicalLines = this.interestingLogicalLines(document2, event.getOffset(), event.getOldLength());
                this.matchingCellsBeforeChange = NotebookCellInlayManager.access$getMatchingCells(this.this$0, NotebookCellInlayManager.access$getNotebookCellLines$p(this.this$0), logicalLines);
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.isBulkModeEnabled) {
                    return;
                }
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                IntRange logicalLines = this.interestingLogicalLines(document, event.getOffset(), event.getNewLength());
                NotebookCellInlayManager.access$ensureInlaysAndHighlightersExist(this.this$0, this.matchingCellsBeforeChange, logicalLines);
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.isBulkModeEnabled = false;
                NotebookCellInlayManager.access$ensureInlaysAndHighlightersExist(this.this$0, this.matchingCellsBeforeChange, RangesKt.until((int)0, (int)document.getLineCount()));
            }
        };
        this.editor.getDocument().addDocumentListener(documentListener2, this.editor.getDisposable());
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureInlaysAndHighlightersExist(List<NotebookCellLines.Interval> matchingCellsBeforeChange, IntRange logicalLines) {
        IntRange intRange;
        Iterable iterable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable2 = matchingCellsBeforeChange;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLines());
        }
        Iterable it = iterable2 = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable3 = iterable = !((Collection)it).isEmpty() ? iterable2 : null;
        if (iterable != null) {
            Iterable it2 = iterable;
            boolean bl2 = false;
            intRange = new IntRange(Math.min(logicalLines.getFirst(), ((IntRange)CollectionsKt.first((List)it2)).getFirst()), Math.max(((IntRange)CollectionsKt.last((List)it2)).getLast(), logicalLines.getLast()));
        } else {
            intRange = logicalLines;
        }
        IntRange interestingRange = intRange;
        this.updateConsequentInlays(interestingRange);
    }

    private final void inlaysChanged() {
        block0: {
            InlaysChangedListener inlaysChangedListener = this.changedListener;
            if (inlaysChangedListener == null) break block0;
            inlaysChangedListener.inlaysChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConsequentInlays(IntRange interestingRange) {
        void destination$iv;
        void $this$mapTo$iv;
        Object highlighter2;
        Map map;
        Iterator<RangeHighlighterEx> $this$associateByTo$iv;
        ThreadingAssertions.softAssertReadAccess();
        NotebookCellEditorScrollingPositionKeeper notebookCellEditorScrollingPositionKeeper = NotebookCellEditorScrollingPositionKeeperKt.getNotebookCellEditorScrollingPositionKeeper((Editor)this.editor);
        if (notebookCellEditorScrollingPositionKeeper != null) {
            notebookCellEditorScrollingPositionKeeper.saveSelectedCellPosition();
        }
        List<NotebookCellLines.Interval> matchingIntervals = this.getMatchingCells(this.notebookCellLines, interestingRange);
        IntRange fullInterestingRange = !((Collection)matchingIntervals).isEmpty() ? new IntRange(((NotebookCellLines.Interval)CollectionsKt.first(matchingIntervals)).getLines().getFirst(), ((NotebookCellLines.Interval)CollectionsKt.last(matchingIntervals)).getLines().getLast()) : interestingRange;
        List<RangeHighlighterEx> existingHighlighters = this.getMatchingHighlightersForLines(fullInterestingRange);
        Iterable iterable = matchingIntervals;
        Map destination$iv2 = new HashMap();
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv = iterator.next();
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
            map = destination$iv2;
            boolean bl = false;
            map.put(it.getLines(), element$iv);
        }
        HashMap intervalsToAddHighlightersFor = (HashMap)destination$iv2;
        for (Object highlighter2 : existingHighlighters) {
            DocumentEx $this$updateConsequentInlays_u24lambda_u247 = this.editor.getDocument();
            boolean bl = false;
            IntRange lines = new IntRange($this$updateConsequentInlays_u24lambda_u247.getLineNumber(highlighter2.getStartOffset()), $this$updateConsequentInlays_u24lambda_u247.getLineNumber(highlighter2.getEndOffset()));
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)intervalsToAddHighlightersFor.remove(lines);
            if (interval != null ? this.getShouldHaveHighlighter(interval) : false) continue;
            this.editor.getMarkupModel().removeHighlighter((RangeHighlighter)highlighter2);
        }
        Collection<NotebookCellLines.Interval> collection = intervalsToAddHighlightersFor.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        this.addHighlighters(collection);
        highlighter2 = this.getMatchingInlaysForLines(fullInterestingRange);
        Collection lines = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NotebookCellInlayController bl = (NotebookCellInlayController)item$iv;
            map = destination$iv;
            boolean bl2 = false;
            map.add(TuplesKt.to((Object)this.editor.getDocument().getLineNumber(it.getInlay().getOffset()), (Object)it));
        }
        List allMatchingInlays = (List)destination$iv;
        List allFactories = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        for (NotebookCellLines.Interval interval : matchingIntervals) {
            Iterable $this$associateWith$iv = allFactories;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                NotebookCellInlayController.Factory factory = (NotebookCellInlayController.Factory)element$iv$iv;
                Object t = element$iv$iv;
                map = result$iv;
                boolean bl = false;
                SmartList smartList = new SmartList();
                map.put(t, smartList);
            }
            Map seenControllersByFactory = result$iv;
            allMatchingInlays.removeIf(arg_0 -> NotebookCellInlayManager.updateConsequentInlays$lambda$10((Function1)new Function1<Pair<? extends Integer, ? extends NotebookCellInlayController>, Boolean>(interval, (Map<NotebookCellInlayController.Factory, ? extends List<NotebookCellInlayController>>)seenControllersByFactory){
                final /* synthetic */ NotebookCellLines.Interval $interval;
                final /* synthetic */ Map<NotebookCellInlayController.Factory, List<NotebookCellInlayController>> $seenControllersByFactory;
                {
                    this.$interval = $interval;
                    this.$seenControllersByFactory = $seenControllersByFactory;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Pair<Integer, ? extends NotebookCellInlayController> pair) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    int inlayLine = ((Number)pair.component1()).intValue();
                    NotebookCellInlayController controller = (NotebookCellInlayController)pair.component2();
                    IntRange intRange = this.$interval.getLines();
                    int n = intRange.getFirst();
                    boolean bl2 = inlayLine <= intRange.getLast() ? n <= inlayLine : false;
                    if (bl2) {
                        List<NotebookCellInlayController> list = this.$seenControllersByFactory.get(controller.getFactory());
                        if (list != null) {
                            list.add(controller);
                        }
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            }, arg_0));
            for (Map.Entry entry2 : seenControllersByFactory.entrySet()) {
                NotebookCellInlayController actualController;
                NotebookCellInlayController.Factory factory = (NotebookCellInlayController.Factory)entry2.getKey();
                List controllers = (List)entry2.getValue();
                NotebookCellInlayController notebookCellInlayController = actualController = !this.editor.isDisposed() ? this.failSafeCompute(factory, this.editor, controllers, this.notebookCellLines.getIntervals().listIterator(interval.getOrdinal())) : null;
                if (actualController != null) {
                    this.rememberController(actualController, interval);
                }
                for (NotebookCellInlayController oldController : controllers) {
                    if (Intrinsics.areEqual((Object)oldController, (Object)actualController)) continue;
                    Disposer.dispose((Disposable)((Disposable)oldController.getInlay()), (boolean)false);
                }
            }
        }
        new NotebookGutterLineMarkerManager().putHighlighters((EditorEx)this.editor);
        Iterator<NotebookCellLines.Interval> iterator2 = allMatchingInlays.iterator();
        while (iterator2.hasNext()) {
            NotebookCellInlayController controller = (NotebookCellInlayController)((Pair)iterator2.next()).component2();
            Disposer.dispose((Disposable)((Disposable)controller.getInlay()), (boolean)false);
        }
        this.inlaysChanged();
    }

    private final void rememberController(NotebookCellInlayController controller, NotebookCellLines.Interval interval) {
        Inlay<?> inlay = controller.getInlay();
        EditorCustomElementRenderer $this$asSafely$iv = inlay.getRenderer();
        boolean $i$f$asSafely = false;
        EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
        if (!(editorCustomElementRenderer instanceof JComponent)) {
            editorCustomElementRenderer = null;
        }
        JComponent jComponent = (JComponent)editorCustomElementRenderer;
        if (jComponent != null) {
            JComponent component = jComponent;
            boolean bl = false;
            DataProvider oldProvider = DataManager.getDataProvider((JComponent)component);
            if (oldProvider != null && !(oldProvider instanceof NotebookCellDataProvider)) {
                LOG.error("Overwriting an existing CLIENT_PROPERTY_DATA_PROVIDER. Old provider: " + oldProvider);
            }
            DataManager.removeDataProvider((JComponent)component);
            DataManager.registerDataProvider((JComponent)component, (DataProvider)new NotebookCellDataProvider(this.editor, component, interval));
        }
        if (this.inlays.put(inlay, controller) != controller) {
            Disposable disposable = () -> NotebookCellInlayManager.rememberController$lambda$13(inlay, this);
            if (Disposer.isDisposed((Disposable)((Disposable)inlay))) {
                disposable.dispose();
            } else {
                Disposer.register((Disposable)((Disposable)inlay), (Disposable)disposable);
            }
        }
    }

    private final List<RangeHighlighterEx> getMatchingHighlightersForLines(IntRange lines) {
        List list;
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        int startOffset = this.editor.getDocument().getLineStartOffset(this.saturateLine(lines.getFirst()));
        int endOffset = this.editor.getDocument().getLineEndOffset(this.saturateLine(lines.getLast()));
        this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(startOffset, endOffset, arg_0 -> NotebookCellInlayManager.getMatchingHighlightersForLines$lambda$15$lambda$14(list2, arg_0));
        return list;
    }

    private final List<NotebookCellInlayController> getMatchingInlaysForLines(IntRange lines) {
        return this.getMatchingInlaysForOffsets(this.editor.getDocument().getLineStartOffset(this.saturateLine(lines.getFirst())), this.editor.getDocument().getLineEndOffset(this.saturateLine(lines.getLast())));
    }

    private final int saturateLine(int line2) {
        return RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)line2, (int)(this.editor.getDocument().getLineCount() - 1)), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotebookCellInlayController> getMatchingInlaysForOffsets(int startOffset, int endOffset) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list = this.editor.getInlayModel().getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Iterable iterable = list;
        Map<Inlay<?>, NotebookCellInlayController> map = this.inlays;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NotebookCellInlayController it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Inlay p0 = (Inlay)element$iv$iv;
            boolean bl2 = false;
            if (map.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean getShouldHaveHighlighter(NotebookCellLines.Interval $this$shouldHaveHighlighter) {
        return $this$shouldHaveHighlighter.getType() == NotebookCellLines.CellType.CODE;
    }

    private final void addHighlighters(Collection<NotebookCellLines.Interval> intervals) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        for (NotebookCellLines.Interval interval : intervals) {
            RangeHighlighter highlighter;
            if (!this.getShouldHaveHighlighter(interval)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.editor.getMarkupModel().addRangeHighlighter(document.getLineStartOffset(interval.getLines().getFirst()), document.getLineEndOffset(interval.getLines().getLast()), 900, this.textAttributesForHighlighter(), HighlighterTargetArea.LINES_IN_RANGE), (String)"addRangeHighlighter(...)");
            highlighter.setCustomRenderer((CustomHighlighterRenderer)NotebookCellHighlighterRenderer.INSTANCE);
        }
    }

    private final TextAttributes textAttributesForHighlighter() {
        TextAttributes textAttributes;
        TextAttributes $this$textAttributesForHighlighter_u24lambda_u2416 = textAttributes = new TextAttributes();
        boolean bl = false;
        NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance((Editor)this.editor);
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        $this$textAttributesForHighlighter_u24lambda_u2416.setBackgroundColor(notebookEditorAppearance.getCodeCellBackground(editorColorsScheme));
        return textAttributes;
    }

    private final List<NotebookCellLines.Interval> getMatchingCells(NotebookCellLines $this$getMatchingCells, IntRange logicalLines) {
        List list;
        List result2 = list = (List)new ArrayList();
        boolean bl = false;
        ListIterator<NotebookCellLines.Interval> iterator = $this$getMatchingCells.intervalsIterator(logicalLines.getFirst());
        if (iterator.hasPrevious()) {
            iterator.previous();
        }
        ListIterator<NotebookCellLines.Interval> listIterator = iterator;
        while (listIterator.hasNext()) {
            NotebookCellLines.Interval interval = listIterator.next();
            result2.add(interval);
            if (interval.getLines().getFirst() <= logicalLines.getLast()) continue;
            break;
        }
        return list;
    }

    private final NotebookCellInlayController failSafeCompute(NotebookCellInlayController.Factory factory, EditorImpl editor, Collection<? extends NotebookCellInlayController> controllers, ListIterator<NotebookCellLines.Interval> intervalIterator) {
        try {
            return factory.compute(editor, controllers, intervalIterator);
        }
        catch (Throwable t) {
            NotebookCellInlayManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookCellInlayManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at NotebookCellInlayController.Factory.compute(...)", t);
            return null;
        }
    }

    @TestOnly
    @NotNull
    public final Map<Inlay<?>, NotebookCellInlayController> getInlays() {
        return this.inlays;
    }

    @TestOnly
    public final void updateControllers(@NotNull List<NotebookCellLines.Interval> matchingCells, @NotNull IntRange logicalLines) {
        Intrinsics.checkNotNullParameter(matchingCells, (String)"matchingCells");
        Intrinsics.checkNotNullParameter((Object)logicalLines, (String)"logicalLines");
        this.ensureInlaysAndHighlightersExist(matchingCells, logicalLines);
    }

    private static final void addViewportChangeListener$lambda$0(NotebookCellInlayManager this$0, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewportQueue.queue(new Update(this$0){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                super((Object)"Viewport change");
            }

            public void run() {
                if (this.this$0.getEditor().isDisposed()) {
                    return;
                }
                for (Map.Entry<K, V> entry2 : NotebookCellInlayManager.access$getInlays$p(this.this$0).entrySet()) {
                    Inlay inlay = (Inlay)entry2.getKey();
                    NotebookCellInlayController controller = (NotebookCellInlayController)entry2.getValue();
                    controller.onViewportChange();
                    Object object = inlay.getRenderer();
                    if (object == null) continue;
                    EditorCustomElementRenderer $this$asSafely$iv = object;
                    boolean $i$f$asSafely = false;
                    EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
                    if (!(editorCustomElementRenderer instanceof JComponent)) {
                        editorCustomElementRenderer = null;
                    }
                    if ((object = (JComponent)editorCustomElementRenderer) == null) continue;
                    ((JComponent)object).updateUI();
                }
            }
        });
    }

    private static final void initialize$lambda$1(NotebookCellInlayManager this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateAll();
        this$0.refreshHighlightersLookAndFeel();
    }

    private static final void initialize$lambda$2(NotebookCellInlayManager this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateAll();
        this$0.refreshHighlightersLookAndFeel();
    }

    private static final boolean updateConsequentInlays$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void rememberController$lambda$13(Inlay $inlay, NotebookCellInlayManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$inlay, (String)"$inlay");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EditorCustomElementRenderer $this$asSafely$iv = $inlay.getRenderer();
        boolean $i$f$asSafely = false;
        EditorCustomElementRenderer editorCustomElementRenderer = $this$asSafely$iv;
        if (!(editorCustomElementRenderer instanceof JComponent)) {
            editorCustomElementRenderer = null;
        }
        JComponent jComponent = (JComponent)editorCustomElementRenderer;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            DataManager.removeDataProvider((JComponent)it);
        }
        this$0.inlays.remove($inlay);
    }

    private static final boolean getMatchingHighlightersForLines$lambda$15$lambda$14(List $list, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        if (it.getCustomRenderer() == NotebookCellHighlighterRenderer.INSTANCE) {
            Intrinsics.checkNotNull((Object)it);
            $list.add(it);
        }
        return true;
    }

    @JvmStatic
    public static final void install(@NotNull EditorImpl editor) {
        Companion.install(editor);
    }

    @JvmStatic
    @Nullable
    public static final NotebookCellInlayManager get(@NotNull Editor editor) {
        return Companion.get(editor);
    }

    public static final /* synthetic */ List access$getMatchingCells(NotebookCellInlayManager $this, NotebookCellLines $receiver, IntRange logicalLines) {
        return $this.getMatchingCells($receiver, logicalLines);
    }

    public static final /* synthetic */ NotebookCellLines access$getNotebookCellLines$p(NotebookCellInlayManager $this) {
        return $this.notebookCellLines;
    }

    public static final /* synthetic */ void access$ensureInlaysAndHighlightersExist(NotebookCellInlayManager $this, List matchingCellsBeforeChange, IntRange logicalLines) {
        $this.ensureInlaysAndHighlightersExist(matchingCellsBeforeChange, logicalLines);
    }

    public /* synthetic */ NotebookCellInlayManager(EditorImpl editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    public static final /* synthetic */ Map access$getInlays$p(NotebookCellInlayManager $this) {
        return $this.inlays;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotebookCellInlayManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)NotebookCellInlayManager.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NotebookCellInlayManager.key = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "key", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "get", "editor", "Lcom/intellij/openapi/editor/Editor;", "install", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            new NotebookCellInlayManager(editor, null).initialize();
        }

        @JvmStatic
        @Nullable
        public final NotebookCellInlayManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookCellInlayManager)key.get((UserDataHolder)editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayManager$NotebookCellDataProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "component", "Ljavax/swing/JComponent;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljavax/swing/JComponent;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)V", "getComponent", "()Ljavax/swing/JComponent;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getInterval", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getData", "key", "", "hashCode", "", "toString", "intellij.notebooks.visualization"})
    private static final class NotebookCellDataProvider
    implements DataProvider {
        @NotNull
        private final EditorImpl editor;
        @NotNull
        private final JComponent component;
        @NotNull
        private final NotebookCellLines.Interval interval;

        public NotebookCellDataProvider(@NotNull EditorImpl editor, @NotNull JComponent component, @NotNull NotebookCellLines.Interval interval) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            this.editor = editor;
            this.component = component;
            this.interval = interval;
        }

        @NotNull
        public final EditorImpl getEditor() {
            return this.editor;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final NotebookCellLines.Interval getInterval() {
            return this.interval;
        }

        @Nullable
        public Object getData(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = key;
            return Intrinsics.areEqual((Object)string, (Object)NotebookCellLinesKt.getNOTEBOOK_CELL_LINES_INTERVAL_DATA_KEY().getName()) ? this.interval : (Intrinsics.areEqual((Object)string, (Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()) ? this.component : (Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.EDITOR.getName()) ? this.editor : null));
        }

        @NotNull
        public final EditorImpl component1() {
            return this.editor;
        }

        @NotNull
        public final JComponent component2() {
            return this.component;
        }

        @NotNull
        public final NotebookCellLines.Interval component3() {
            return this.interval;
        }

        @NotNull
        public final NotebookCellDataProvider copy(@NotNull EditorImpl editor, @NotNull JComponent component, @NotNull NotebookCellLines.Interval interval) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            return new NotebookCellDataProvider(editor, component, interval);
        }

        public static /* synthetic */ NotebookCellDataProvider copy$default(NotebookCellDataProvider notebookCellDataProvider, EditorImpl editorImpl, JComponent jComponent, NotebookCellLines.Interval interval, int n, Object object) {
            if ((n & 1) != 0) {
                editorImpl = notebookCellDataProvider.editor;
            }
            if ((n & 2) != 0) {
                jComponent = notebookCellDataProvider.component;
            }
            if ((n & 4) != 0) {
                interval = notebookCellDataProvider.interval;
            }
            return notebookCellDataProvider.copy(editorImpl, jComponent, interval);
        }

        @NotNull
        public String toString() {
            return "NotebookCellDataProvider(editor=" + this.editor + ", component=" + this.component + ", interval=" + this.interval + ")";
        }

        public int hashCode() {
            int result2 = this.editor.hashCode();
            result2 = result2 * 31 + this.component.hashCode();
            result2 = result2 * 31 + this.interval.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotebookCellDataProvider)) {
                return false;
            }
            NotebookCellDataProvider notebookCellDataProvider = (NotebookCellDataProvider)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)notebookCellDataProvider.editor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.component, (Object)notebookCellDataProvider.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.interval, (Object)notebookCellDataProvider.interval);
        }
    }
}

