/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookCellLineNumbersLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookCodeCellBackgroundLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookTextCellBackgroundLineMarkerRenderer;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayManager;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookVisualizationUiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager;", "", "()V", "attachHighlighters", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "paintBackground", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "putHighlighters", "Companion", "NotebookGutterLineMarkerRenderer", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookGutterLineMarkerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookGutterLineMarkerManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n3792#2:134\n4307#2,2:135\n1855#3,2:137\n*S KotlinDebug\n*F\n+ 1 NotebookGutterLineMarkerManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager\n*L\n39#1:134\n39#1:135,2\n40#1:137,2\n*E\n"})
public final class NotebookGutterLineMarkerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void attachHighlighters(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookVisualizationUiUtilKt.addEditorDocumentListener((Editor)editor, new DocumentListener(this, editor){
            final /* synthetic */ NotebookGutterLineMarkerManager this$0;
            final /* synthetic */ EditorEx $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.putHighlighters(this.$editor);
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.this$0.putHighlighters(this.$editor);
            }
        });
        editor.getCaretModel().addCaretListener(new CaretListener(this, editor){
            final /* synthetic */ NotebookGutterLineMarkerManager this$0;
            final /* synthetic */ EditorEx $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.putHighlighters(this.$editor);
            }
        });
        this.putHighlighters(editor);
    }

    public final void putHighlighters(@NotNull EditorEx editor) {
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RangeHighlighter[] rangeHighlighterArray = editor.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$filter$iv = rangeHighlighterArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            if (!(it.getLineMarkerRenderer() instanceof NotebookLineMarkerRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List highlighters = (List)destination$iv$iv;
        Iterable $this$forEach$iv = highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            editor.getMarkupModel().removeHighlighter(it);
        }
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get((Editor)editor);
        for (NotebookCellLines.Interval interval : notebookCellLines.getIntervals()) {
            NotebookCellInlayManager notebookCellInlayManager;
            RangeHighlighter bl;
            int startOffset = editor.getDocument().getLineStartOffset(interval.getLines().getFirst());
            int endOffset = editor.getDocument().getLineEndOffset(interval.getLines().getLast());
            RangeHighlighter it = bl = editor.getMarkupModel().addRangeHighlighter(null, startOffset, endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE);
            boolean bl2 = false;
            it.setLineMarkerRenderer((LineMarkerRenderer)new NotebookGutterLineMarkerRenderer(interval));
            if (interval.getType() == NotebookCellLines.CellType.CODE && NotebookUtilKt.getNotebookAppearance((Editor)editor).shouldShowCellLineNumbers() && editor.getEditorKind() != EditorKind.DIFF) {
                it = bl = editor.getMarkupModel().addRangeHighlighter(null, startOffset, endOffset, 901, HighlighterTargetArea.LINES_IN_RANGE);
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                it.setLineMarkerRenderer((LineMarkerRenderer)new NotebookCellLineNumbersLineMarkerRenderer(it));
            }
            if (interval.getType() == NotebookCellLines.CellType.CODE) {
                changeAction = NotebookGutterLineMarkerManager::putHighlighters$lambda$4;
                editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, changeAction);
            } else if (editor.getEditorKind() != EditorKind.DIFF) {
                changeAction = NotebookGutterLineMarkerManager::putHighlighters$lambda$5;
                editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, changeAction);
            }
            if (NotebookCellInlayManager.Companion.get((Editor)editor) == null) {
                throw new AssertionError((Object)"Register inlay manager first");
            }
            for (NotebookCellInlayController controller : notebookCellInlayManager.inlaysForInterval(interval)) {
                controller.createGutterRendererLineMarker(editor, interval);
            }
        }
    }

    public final void paintBackground(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        if (notebookCellInlayManager == null) {
            throw new AssertionError((Object)"Register inlay manager first");
        }
        NotebookCellInlayManager notebookCellInlayManager2 = notebookCellInlayManager;
        for (NotebookCellInlayController controller : notebookCellInlayManager2.inlaysForInterval(interval)) {
            controller.paintGutter(editor, g, r, interval);
        }
    }

    private static final void putHighlighters$lambda$4(RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookCodeCellBackgroundLineMarkerRenderer((RangeHighlighter)o));
    }

    private static final void putHighlighters$lambda$5(RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookTextCellBackgroundLineMarkerRenderer((RangeHighlighter)o));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager$Companion;", "", "()V", "install", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookGutterLineMarkerManager install(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookGutterLineMarkerManager instance = new NotebookGutterLineMarkerManager();
            instance.attachHighlighters(editor);
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager$NotebookGutterLineMarkerRenderer;", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookLineMarkerRenderer;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager;Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookGutterLineMarkerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookGutterLineMarkerManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager$NotebookGutterLineMarkerRenderer\n+ 2 NotebookVisualizationUiUtil.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookVisualizationUiUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n22#2,2:134\n26#2,2:137\n1#3:136\n*S KotlinDebug\n*F\n+ 1 NotebookGutterLineMarkerManager.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookGutterLineMarkerManager$NotebookGutterLineMarkerRenderer\n*L\n104#1:134,2\n104#1:137,2\n*E\n"})
    public final class NotebookGutterLineMarkerRenderer
    extends NotebookLineMarkerRenderer {
        @NotNull
        private final NotebookCellLines.Interval interval;

        public NotebookGutterLineMarkerRenderer(NotebookCellLines.Interval interval) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            super(null, 1, null);
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            void $this$use$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            EditorImpl cfr_ignored_0 = (EditorImpl)editor;
            Graphics graphics = g.create();
            NotebookGutterLineMarkerManager notebookGutterLineMarkerManager = NotebookGutterLineMarkerManager.this;
            boolean $i$f$use = false;
            try {
                void $this$paint_u24lambda_u241_u24lambda_u240;
                void g2 = $this$use$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D cfr_ignored_1 = (Graphics2D)g2;
                int visualLineStart = editor.xyToVisualPosition((Point)new Point((int)0, (int)((Graphics2D)g2).getClip().getBounds().y)).line;
                Rectangle rectangle = ((Graphics2D)g2).getClip().getBounds();
                int n = 0;
                Editor editor2 = editor;
                boolean bl2 = false;
                int n2 = $this$paint_u24lambda_u241_u24lambda_u240.y + $this$paint_u24lambda_u241_u24lambda_u240.height;
                int n3 = n2;
                int n4 = n;
                int visualLineEnd = editor2.xyToVisualPosition((Point)new Point((int)n4, (int)n3)).line;
                int logicalLineStart = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineStart, (int)0)).line;
                int logicalLineEnd = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLineEnd, (int)0)).line;
                if (this.interval.getLines().getFirst() > logicalLineEnd || this.interval.getLines().getLast() < logicalLineStart) {
                    return;
                }
                notebookGutterLineMarkerManager.paintBackground((EditorImpl)editor, (Graphics)g2, r, this.interval);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.dispose();
            }
        }
    }
}

