/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.sh.ShBundle;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ShellcheckOptionsPanel {
    private JPanel myPanel;
    private JPanel myWarningPanel;
    private JLabel myWarningLabel;
    private JLabel myErrorLabel;
    private ActionLink myShellcheckDownloadLink;
    private TextFieldWithBrowseButton myShellcheckSelector;
    private MultipleCheckboxOptionsPanel myInspectionsCheckboxPanel;
    private final BiConsumer<String, Boolean> myInspectionsChangeListener;
    private final Set<String> myDisabledInspections;
    private final Project myProject;

    ShellcheckOptionsPanel(Set<String> disabledInspections, BiConsumer<String, Boolean> inspectionsChangeListener) {
        this.myInspectionsChangeListener = inspectionsChangeListener;
        this.myDisabledInspections = disabledInspections;
        this.$$$setupUI$$$();
        this.myProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        this.myShellcheckSelector.addBrowseFolderListener(ShBundle.message("sh.shellcheck.path.label", new Object[0]), "", this.myProject, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myShellcheckSelector.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                String shellcheckPath = ShellcheckOptionsPanel.this.myShellcheckSelector.getText();
                ShSettings.setShellcheckPath(shellcheckPath);
                ShellcheckOptionsPanel.this.myWarningPanel.setVisible(!ShShellcheckUtil.isValidPath(shellcheckPath));
                ShellcheckOptionsPanel.this.myErrorLabel.setVisible(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/intellij/sh/shellcheck/ShellcheckOptionsPanel$1", "textChanged"));
            }
        });
        String shellcheckPath = ShSettings.getShellcheckPath();
        this.myShellcheckSelector.setText(shellcheckPath);
        this.myWarningPanel.setVisible(!ShShellcheckUtil.isValidPath(shellcheckPath));
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        ShShellcheckUtil.SHELLCHECK_CODES.forEach((key, value) -> this.myInspectionsCheckboxPanel.addCheckbox(key + " " + value, key));
        this.myWarningLabel.setIcon(AllIcons.General.Warning);
    }

    private void createUIComponents() {
        this.myShellcheckDownloadLink = new ActionLink(ShBundle.message("sh.shellcheck.download.label.text", new Object[0]), e -> {
            ShShellcheckUtil.download(this.myProject, () -> this.myShellcheckSelector.setText(ShSettings.getShellcheckPath()), () -> this.myErrorLabel.setVisible(true));
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        });
        this.myInspectionsCheckboxPanel = new MultipleCheckboxOptionsPanel(new OptionAccessor(){

            public boolean getOption(String optionName) {
                return ShellcheckOptionsPanel.this.myDisabledInspections.contains(optionName);
            }

            public void setOption(String optionName, boolean optionValue) {
                ShellcheckOptionsPanel.this.myInspectionsChangeListener.accept(optionName, optionValue);
            }
        });
    }

    JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 5), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ShBundle", ShellcheckOptionsPanel.class).getString("sh.path.label"));
        jLabel2.setVerticalAlignment(0);
        jLabel2.setVerticalTextPosition(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShellcheckSelector = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myWarningPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        ((Component)jPanel).setEnabled(true);
        ((Component)jPanel).setVisible(false);
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 9, 0, 3, 3, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShellcheckOptionsPanel.class).getString("sh.invalid.path"));
        Component component = jPanel.add(jLabel);
        ActionLink actionLink = this.myShellcheckDownloadLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/ShBundle", ShellcheckOptionsPanel.class).getString("sh.download"));
        Component component2 = jPanel.add((Component)actionLink);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/ShBundle", ShellcheckOptionsPanel.class).getString("sh.shellcheck.missing"));
        Component component3 = jPanel.add(jLabel3);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        MultipleCheckboxOptionsPanel multipleCheckboxOptionsPanel = this.myInspectionsCheckboxPanel;
        jPanel3.add((Component)multipleCheckboxOptionsPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.myErrorLabel = jBLabel;
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShellcheckOptionsPanel.class).getString("sh.shellcheck.cannot.download"));
        jBLabel.setVisible(false);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 9, 0, 0, 0, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

