/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRViewedStateDiffSupport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRViewedStateDiffSupportImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRViewedStateDiffSupport;", "repository", "Lgit4idea/repo/GitRepository;", "viewedStateData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProvider;", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProvider;)V", "markViewed", "", "file", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.github"})
public final class GHPRViewedStateDiffSupportImpl
implements GHPRViewedStateDiffSupport {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GHPRViewedStateDataProvider viewedStateData;

    public GHPRViewedStateDiffSupportImpl(@NotNull GitRepository repository, @NotNull GHPRViewedStateDataProvider viewedStateData) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)viewedStateData, (String)"viewedStateData");
        this.repository = repository;
        this.viewedStateData = viewedStateData;
    }

    @Override
    public void markViewed(@NotNull FilePath file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String repositoryRelativePath = VcsFileUtil.relativePath((VirtualFile)this.repository.getRoot(), (FilePath)file);
        Intrinsics.checkNotNull((Object)repositoryRelativePath);
        this.viewedStateData.updateViewedState(repositoryRelativePath, true);
    }
}

