/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsPanel;", "", "()V", "create", "Ljavax/swing/JComponent;", "model", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "threadComponentFactory", "Lkotlin/Function1;", "Controller", "intellij.vcs.github"})
public final class GHPRReviewThreadsPanel {
    @NotNull
    public static final GHPRReviewThreadsPanel INSTANCE = new GHPRReviewThreadsPanel();

    private GHPRReviewThreadsPanel() {
    }

    @NotNull
    public final JComponent create(@NotNull ListModel<GHPRReviewThreadModel> model2, @NotNull Function1<? super GHPRReviewThreadModel, ? extends JComponent> threadComponentFactory) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(threadComponentFactory, (String)"threadComponentFactory");
        JPanel panel = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        new Controller(model2, panel, threadComponentFactory);
        return panel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsPanel$Controller;", "", "model", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "panel", "Ljavax/swing/JPanel;", "threadComponentFactory", "Lkotlin/Function1;", "Ljavax/swing/JComponent;", "(Ljavax/swing/ListModel;Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function1;)V", "updateVisibility", "", "intellij.vcs.github"})
    private static final class Controller {
        @NotNull
        private final ListModel<GHPRReviewThreadModel> model;
        @NotNull
        private final JPanel panel;
        @NotNull
        private final Function1<GHPRReviewThreadModel, JComponent> threadComponentFactory;

        public Controller(@NotNull ListModel<GHPRReviewThreadModel> model2, @NotNull JPanel panel, @NotNull Function1<? super GHPRReviewThreadModel, ? extends JComponent> threadComponentFactory) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter(threadComponentFactory, (String)"threadComponentFactory");
            this.model = model2;
            this.panel = panel;
            this.threadComponentFactory = threadComponentFactory;
            this.model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int i = e.getIndex1();
                    int n = e.getIndex0();
                    if (n <= i) {
                        while (true) {
                            panel.remove(i);
                            if (i == n) break;
                            --i;
                        }
                    }
                    this.updateVisibility();
                    panel.revalidate();
                    panel.repaint();
                }

                @Override
                public void intervalAdded(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int i = e.getIndex0();
                    int n = e.getIndex1();
                    if (i <= n) {
                        while (true) {
                            JPanel jPanel = panel;
                            Function1 function1 = threadComponentFactory;
                            Object e2 = model.getElementAt(i);
                            Intrinsics.checkNotNullExpressionValue(e2, (String)"getElementAt(...)");
                            jPanel.add((Component)function1.invoke(e2), i);
                            if (i == n) break;
                            ++i;
                        }
                    }
                    this.updateVisibility();
                    panel.revalidate();
                    panel.repaint();
                }

                @Override
                public void contentsChanged(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.updateVisibility();
                    panel.validate();
                    panel.repaint();
                }
            });
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                GHPRReviewThreadModel gHPRReviewThreadModel = this.model.getElementAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)gHPRReviewThreadModel, (String)"getElementAt(...)");
                this.panel.add((Component)this.threadComponentFactory.invoke((Object)gHPRReviewThreadModel), i);
            }
            this.updateVisibility();
        }

        private final void updateVisibility() {
            this.panel.setVisible(this.panel.getComponentCount() > 0);
        }
    }
}

