/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.sentry.SentryEnvelopeItemHeader;
import io.sentry.SentryItemType;
import io.sentry.util.StringUtils;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryEnvelopeItemHeaderAdapter
extends TypeAdapter<SentryEnvelopeItemHeader> {
    @Override
    public void write(JsonWriter writer, SentryEnvelopeItemHeader value2) throws IOException {
        if (value2 == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value2.getContentType() != null) {
            writer.name("content_type");
            writer.value(value2.getContentType());
        }
        if (value2.getFileName() != null) {
            writer.name("filename");
            writer.value(value2.getFileName());
        }
        if (!SentryItemType.Unknown.equals((Object)value2.getType())) {
            writer.name("type");
            writer.value(value2.getType().getItemType().toLowerCase(Locale.ROOT));
        }
        if (value2.getAttachmentType() != null) {
            writer.name("attachment_type");
            writer.value(value2.getAttachmentType());
        }
        writer.name("length");
        writer.value(value2.getLength());
        writer.endObject();
    }

    @Override
    @Nullable
    public SentryEnvelopeItemHeader read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String contentType = null;
        String fileName = null;
        SentryItemType type2 = SentryItemType.Unknown;
        int length = 0;
        String attachmentType = null;
        reader.beginObject();
        block16: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "content_type": {
                    contentType = reader.nextString();
                    break;
                }
                case "filename": {
                    fileName = reader.nextString();
                    break;
                }
                case "type": {
                    try {
                        String nextString = reader.nextString();
                        if (nextString == null) continue block16;
                        if (nextString.equalsIgnoreCase("user_report")) {
                            type2 = SentryItemType.UserFeedback;
                            break;
                        }
                        String capitalizedString = StringUtils.capitalize(nextString);
                        if (capitalizedString == null) continue block16;
                        type2 = SentryItemType.valueOf(capitalizedString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case "length": {
                    length = reader.nextInt();
                    break;
                }
                case "attachment_type": {
                    attachmentType = reader.nextString();
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        return new SentryEnvelopeItemHeader(type2, length, contentType, fileName, attachmentType);
    }
}

