/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.util.Hashtable;
import java.util.Map;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateType;

public class FoundationsRegistry {
    private int lastAssignedFoundation = 0;
    private int lastAssignedRemoteFoundation = 10000;
    private Map<String, String> foundations = new Hashtable<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignFoundation(Candidate<?> candidate) {
        String server;
        CandidateType candidateType = candidate.getType();
        String type2 = candidateType.toString();
        String base = ((Candidate)candidate.getBase()).getTransportAddress().getHostAddress();
        switch (candidateType) {
            case SERVER_REFLEXIVE_CANDIDATE: {
                TransportAddress serverAddress = candidate.getStunServerAddress();
                server = serverAddress == null ? "" : serverAddress.getHostAddress();
                break;
            }
            case RELAYED_CANDIDATE: {
                server = candidate.getRelayServerAddress().getHostAddress();
                break;
            }
            default: {
                server = null;
            }
        }
        String transport = candidate.getTransport().toString();
        StringBuffer foundationStringBuff = new StringBuffer(type2);
        foundationStringBuff.append(base);
        if (server != null) {
            foundationStringBuff.append(server);
        }
        foundationStringBuff.append(transport);
        String foundationString = foundationStringBuff.toString();
        String foundationValue = null;
        Map<String, String> map = this.foundations;
        synchronized (map) {
            foundationValue = this.foundations.get(foundationString);
            if (foundationValue == null) {
                foundationValue = Integer.toString(++this.lastAssignedFoundation);
                this.foundations.put(foundationString, foundationValue);
            }
        }
        candidate.setFoundation(foundationValue);
    }

    public String obtainFoundationForPeerReflexiveCandidate() {
        return Integer.toString(this.lastAssignedRemoteFoundation++);
    }

    public int size() {
        return this.foundations.size();
    }
}

