/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.rtcp.KeyframeRequester;
import org.jitsi.nlj.rtcp.NackHandler;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpSrUpdater;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation.GoogleCcEstimator;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.transform.NodeEventVisitor;
import org.jitsi.nlj.transform.NodeStatsVisitor;
import org.jitsi.nlj.transform.NodeTeardownVisitor;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.AudioRedHandler;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.PacketCacher;
import org.jitsi.nlj.transform.node.PacketLossConfig;
import org.jitsi.nlj.transform.node.PacketLossNode;
import org.jitsi.nlj.transform.node.PacketStreamStatsNode;
import org.jitsi.nlj.transform.node.SrtcpEncryptNode;
import org.jitsi.nlj.transform.node.SrtpEncryptNode;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.outgoing.AbsSendTime;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtEncoder;
import org.jitsi.nlj.transform.node.outgoing.HeaderExtStripper;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsTracker;
import org.jitsi.nlj.transform.node.outgoing.ProbingDataSender;
import org.jitsi.nlj.transform.node.outgoing.RetransmissionSender;
import org.jitsi.nlj.transform.node.outgoing.SentRtcpStats;
import org.jitsi.nlj.transform.node.outgoing.TccSeqNumTagger;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008f\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u00011\u0018\u0000 s2\u00020\u0001:\u0001sB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020J2\u0006\u0010N\u001a\u00020OH\u0014J\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020J2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020:2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010\\\u001a\u00020:2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020J2\u0006\u0010`\u001a\u00020+H\u0016J\u0010\u0010a\u001a\u00020J2\u0006\u0010b\u001a\u00020cH\u0016J\u0017\u0010d\u001a\u00020J2\b\u0010e\u001a\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010fJ\u001e\u0010g\u001a\u00020h2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\"0j2\u0006\u0010k\u001a\u00020hH\u0016J\u0018\u0010l\u001a\u00020J2\u0006\u0010]\u001a\u00020^2\u0006\u0010m\u001a\u00020:H\u0016J\u0010\u0010n\u001a\u00020J2\u0006\u0010o\u001a\u00020pH\u0016J\b\u0010q\u001a\u00020JH\u0016J\b\u0010r\u001a\u00020JH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u0012\u0010$\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010%\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006t"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl;", "Lorg/jitsi/nlj/RtpSender;", "id", "", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "executor", "Ljava/util/concurrent/ExecutorService;", "backgroundExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "(Ljava/lang/String;Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/nlj/util/StreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "absSendTime", "Lorg/jitsi/nlj/transform/node/outgoing/AbsSendTime;", "getBackgroundExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "bandwidthEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "getBandwidthEstimator", "()Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "getId", "()Ljava/lang/String;", "incomingPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "keyframeRequester", "Lorg/jitsi/nlj/rtcp/KeyframeRequester;", "localAudioSsrc", "", "Ljava/lang/Long;", "localVideoSsrc", "logger", "nackHandler", "Lorg/jitsi/nlj/rtcp/NackHandler;", "outgoingPacketCache", "Lorg/jitsi/nlj/transform/node/PacketCacher;", "outgoingPacketHandler", "Lorg/jitsi/nlj/PacketHandler;", "outgoingRtcpRoot", "Lorg/jitsi/nlj/transform/node/Node;", "outgoingRtpRoot", "outgoingRtxRoot", "outputPipelineTerminationNode", "org/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1", "Lorg/jitsi/nlj/RtpSenderImpl$outputPipelineTerminationNode$1;", "packetStreamStats", "Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode;", "probingDataSender", "Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender;", "rtcpSrUpdater", "Lorg/jitsi/nlj/rtcp/RtcpSrUpdater;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "srtcpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtcpEncryptNode;", "srtpEncryptWrapper", "Lorg/jitsi/nlj/transform/node/SrtpEncryptNode;", "statsTracker", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "transportCcEngine", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "addLossListener", "", "lossListener", "Lorg/jitsi/nlj/rtp/LossListener;", "doProcessPacket", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getPacketStreamStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getStreamStats", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getTransportCcEngineStats", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "handlePacket", "isFeatureEnabled", "feature", "Lorg/jitsi/nlj/Features;", "onOutgoingPacket", "handler", "onRttUpdate", "newRttMs", "", "requestKeyframe", "mediaSsrc", "(Ljava/lang/Long;)V", "sendProbing", "", "mediaSsrcs", "", "numBytes", "setFeature", "enabled", "setSrtpTransformers", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "stop", "tearDown", "Companion", "jitsi-media-transform"})
public final class RtpSenderImpl
extends RtpSender {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ScheduledExecutorService backgroundExecutor;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Node outgoingRtpRoot;
    @NotNull
    private final Node outgoingRtxRoot;
    @NotNull
    private final Node outgoingRtcpRoot;
    @NotNull
    private final PacketInfoQueue incomingPacketQueue;
    private boolean running;
    @Nullable
    private Long localVideoSsrc;
    @Nullable
    private Long localAudioSsrc;
    @Nullable
    private PacketHandler outgoingPacketHandler;
    @NotNull
    private final BandwidthEstimator bandwidthEstimator;
    @NotNull
    private final TransportCcEngine transportCcEngine;
    @NotNull
    private final SrtpEncryptNode srtpEncryptWrapper;
    @NotNull
    private final SrtcpEncryptNode srtcpEncryptWrapper;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final PacketCacher outgoingPacketCache;
    @NotNull
    private final AbsSendTime absSendTime;
    @NotNull
    private final OutgoingStatisticsTracker statsTracker;
    @NotNull
    private final PacketStreamStatsNode packetStreamStats;
    @NotNull
    private final RtcpSrUpdater rtcpSrUpdater;
    @NotNull
    private final KeyframeRequester keyframeRequester;
    @NotNull
    private final ProbingDataSender probingDataSender;
    @NotNull
    private final NackHandler nackHandler;
    @NotNull
    private final outputPipelineTerminationNode.1 outputPipelineTerminationNode;
    @NotNull
    private static final CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final String PACKET_QUEUE_ENTRY_EVENT = "Entered RTP sender incoming queue";
    @NotNull
    private static final String PACKET_QUEUE_EXIT_EVENT = "Exited RTP sender incoming queue";
    @NotNull
    private static final ConfigDelegate<Integer> queueSize$delegate;
    @NotNull
    private static final PacketLossConfig packetLossConfig;

    public RtpSenderImpl(@NotNull String id, @NotNull RtcpEventNotifier rtcpEventNotifier2, @NotNull ExecutorService executor, @NotNull ScheduledExecutorService backgroundExecutor, @NotNull StreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(rtcpEventNotifier2, "rtcpEventNotifier");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(backgroundExecutor, "backgroundExecutor");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.id = id;
        this.rtcpEventNotifier = rtcpEventNotifier2;
        this.executor = executor;
        this.backgroundExecutor = backgroundExecutor;
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.incomingPacketQueue = new PacketInfoQueue("rtp-sender-incoming-packet-queue", this.executor, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return RtpSenderImpl.access$handlePacket((RtpSenderImpl)this.receiver, p0);
            }
        }, RtpSenderImpl.Companion.getQueueSize());
        this.running = true;
        this.bandwidthEstimator = new GoogleCcEstimator(diagnosticContext, this.logger);
        this.transportCcEngine = new TransportCcEngine(this.getBandwidthEstimator(), this.logger, null, 4, null);
        this.srtpEncryptWrapper = new SrtpEncryptNode();
        this.srtcpEncryptWrapper = new SrtcpEncryptNode();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.logger, this.id + "-tx");
        this.outgoingPacketCache = new PacketCacher();
        this.absSendTime = new AbsSendTime(this.streamInformationStore);
        this.statsTracker = new OutgoingStatisticsTracker();
        this.packetStreamStats = new PacketStreamStatsNode(null, 1, null);
        this.rtcpSrUpdater = new RtcpSrUpdater(this.statsTracker);
        this.keyframeRequester = new KeyframeRequester(this.streamInformationStore, this.logger, null, 4, null);
        this.outputPipelineTerminationNode = new ConsumerNode(this){
            @NotNull
            private final String aggregationKey;
            final /* synthetic */ RtpSenderImpl this$0;
            {
                this.this$0 = $receiver;
                super("Output pipeline termination node");
                this.aggregationKey = this.getName();
            }

            protected void consume(@NotNull PacketInfo packetInfo) {
                Unit unit;
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                PacketHandler packetHandler = RtpSenderImpl.access$getOutgoingPacketHandler$p(this.this$0);
                if (packetHandler != null) {
                    packetHandler.processPacket(packetInfo);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    this.packetDiscarded(packetInfo);
                }
            }

            @NotNull
            protected String getAggregationKey() {
                return this.aggregationKey;
            }

            public void trace(@NotNull Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        };
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Sender " + this.id + " using executor " + this.executor.hashCode());
        }
        if (packetLossConfig.getEnabled()) {
            this.logger.warn("Will simulate packet loss: " + packetLossConfig);
        }
        this.incomingPacketQueue.setErrorHandler(queueErrorCounter);
        this.outgoingRtpRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

            @Override
            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                PipelineBuilder.node$default($this$pipeline, new AudioRedHandler(streamInformationStore, logger), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, new HeaderExtStripper(streamInformationStore), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, outgoingPacketCache, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, absSendTime, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, statsTracker, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, new TccSeqNumTagger(transportCcEngine, streamInformationStore), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, new HeaderExtEncoder(streamInformationStore, logger), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, toggleablePcapWriter.newObserverNode(), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, srtpEncryptWrapper, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, packetStreamStats.createNewNode(), null, 2, null);
                $this$pipeline.node(new PacketLossNode(packetLossConfig), 1.INSTANCE);
                PipelineBuilder.node$default($this$pipeline, outputPipelineTerminationNode, null, 2, null);
            }
        });
        this.outgoingRtxRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

            @Override
            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                PipelineBuilder.node$default($this$pipeline, new RetransmissionSender(streamInformationStore, logger), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, absSendTime, null, 2, null);
            }
        });
        this.nackHandler = new NackHandler(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.logger);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.nackHandler, false, 2, null);
        RtcpEventNotifier.addRtcpEventListener$default(this.rtcpEventNotifier, this.transportCcEngine, false, 2, null);
        this.outgoingRtcpRoot = PipelineDslKt.pipeline((Function1<? super PipelineBuilder, Unit>)new Function1<PipelineBuilder, Unit>(){

            @Override
            public final void invoke(@NotNull PipelineBuilder $this$pipeline) {
                Intrinsics.checkNotNullParameter($this$pipeline, "$this$pipeline");
                PipelineBuilder.node$default($this$pipeline, keyframeRequester, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, new SentRtcpStats(), null, 2, null);
                $this$pipeline.simpleNode("RTCP sender ssrc setter", (Function1<? super PacketInfo, ? extends PacketInfo>)new Function1<PacketInfo, PacketInfo>(){

                    @Override
                    @Nullable
                    public final PacketInfo invoke(@NotNull PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        Long l = localVideoSsrc;
                        if (l == null) {
                            return packetInfo;
                        }
                        long senderSsrc = l;
                        RtcpPacket rtcpPacket = (RtcpPacket)packetInfo.packetAs();
                        if (rtcpPacket.getSenderSsrc() == 0L) {
                            rtcpPacket.setSenderSsrc(senderSsrc);
                        }
                        return packetInfo;
                    }
                });
                PipelineBuilder.node$default($this$pipeline, rtcpSrUpdater, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, toggleablePcapWriter.newObserverNode(), null, 2, null);
                PipelineBuilder.node$default($this$pipeline, srtcpEncryptWrapper, null, 2, null);
                PipelineBuilder.node$default($this$pipeline, packetStreamStats.createNewNode(), null, 2, null);
                $this$pipeline.node(new PacketLossNode(packetLossConfig), 2.INSTANCE);
                PipelineBuilder.node$default($this$pipeline, outputPipelineTerminationNode, null, 2, null);
            }
        });
        this.probingDataSender = new ProbingDataSender(this.outgoingPacketCache.getPacketCache(), this.outgoingRtxRoot, this.absSendTime, diagnosticContext, this.streamInformationStore, this.logger);
    }

    public /* synthetic */ RtpSenderImpl(String string, RtcpEventNotifier rtcpEventNotifier2, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, StreamInformationStore streamInformationStore, Logger logger, DiagnosticContext diagnosticContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            diagnosticContext = new DiagnosticContext();
        }
        this(string, rtcpEventNotifier2, executorService, scheduledExecutorService, streamInformationStore, logger, diagnosticContext);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ExecutorService getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ScheduledExecutorService getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    @Override
    @NotNull
    public BandwidthEstimator getBandwidthEstimator() {
        return this.bandwidthEstimator;
    }

    @Override
    public void onRttUpdate(double newRttMs) {
        this.nackHandler.onRttUpdate(newRttMs);
        this.keyframeRequester.onRttUpdate(newRttMs);
        Duration duration = Duration.ofNanos((long)(newRttMs * 1000000.0));
        Intrinsics.checkNotNullExpressionValue(duration, "ofNanos((newRttMs * 1e6).toLong())");
        this.transportCcEngine.onRttUpdate(duration);
    }

    @Override
    protected void doProcessPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (this.running) {
            Packet packet = packetInfo.getPacket();
            if (packet instanceof RtcpPacket) {
                RtcpEventNotifier.notifyRtcpSent$default(this.rtcpEventNotifier, (RtcpPacket)packet, false, 2, null);
            }
            packetInfo.addEvent(PACKET_QUEUE_ENTRY_EVENT);
            this.incomingPacketQueue.add(packetInfo);
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
            function1.invoke(packetInfo.getPacket().buffer);
        }
    }

    @Override
    public int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, "mediaSsrcs");
        return this.probingDataSender.sendProbing(mediaSsrcs, numBytes);
    }

    @Override
    public void onOutgoingPacket(@NotNull PacketHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.outgoingPacketHandler = handler;
    }

    @Override
    public void setSrtpTransformers(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.srtpEncryptWrapper.setTransformer(srtpTransformers.getSrtpEncryptTransformer());
        this.srtcpEncryptWrapper.setTransformer(srtpTransformers.getSrtcpEncryptTransformer());
    }

    @Override
    public void requestKeyframe(@Nullable Long mediaSsrc) {
        this.keyframeRequester.requestKeyframe(mediaSsrc);
    }

    @Override
    public void addLossListener(@NotNull LossListener lossListener) {
        Intrinsics.checkNotNullParameter(lossListener, "lossListener");
        this.transportCcEngine.addLossListener(lossListener);
    }

    @Override
    public void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] == 1) {
            if (enabled2) {
                this.toggleablePcapWriter.enable();
            } else {
                this.toggleablePcapWriter.disable();
            }
        }
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Features feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.toggleablePcapWriter.isEnabled();
    }

    private final boolean handlePacket(PacketInfo packetInfo) {
        boolean bl;
        if (this.running) {
            packetInfo.addEvent(PACKET_QUEUE_EXIT_EVENT);
            Node root = packetInfo.getPacket() instanceof RtcpPacket ? this.outgoingRtcpRoot : this.outgoingRtpRoot;
            root.processPacket(packetInfo);
            bl = true;
        } else {
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
            function1.invoke(packetInfo.getPacket().buffer);
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public OutgoingStatisticsSnapshot getStreamStats() {
        return this.statsTracker.getSnapshot();
    }

    @Override
    @NotNull
    public PacketStreamStats.Snapshot getPacketStreamStats() {
        return this.packetStreamStats.snapshot();
    }

    @Override
    @NotNull
    public TransportCcEngine.StatisticsSnapshot getTransportCcEngineStats() {
        return this.transportCcEngine.getStatistics();
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetLocalSsrcEvent) {
            switch (WhenMappings.$EnumSwitchMapping$1[((SetLocalSsrcEvent)event).getMediaType().ordinal()]) {
                case 1: {
                    this.localVideoSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                    break;
                }
                case 2: {
                    this.localAudioSsrc = ((SetLocalSsrcEvent)event).getSsrc();
                }
            }
        }
        new NodeEventVisitor(event).reverseVisit(this.outputPipelineTerminationNode);
        this.probingDataSender.handleEvent(event);
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = new NodeStatsBlock("RTP sender " + this.id);
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d1.addBlock(this.nackHandler.getNodeStats());
        $this$getNodeStats_u24lambda_u2d1.addBlock(this.probingDataSender.getNodeStats());
        JSONObject jSONObject = this.incomingPacketQueue.getDebugState();
        Intrinsics.checkNotNullExpressionValue(jSONObject, "incomingPacketQueue.debugState");
        $this$getNodeStats_u24lambda_u2d1.addJson("packetQueue", jSONObject);
        new NodeStatsVisitor($this$getNodeStats_u24lambda_u2d1).reverseVisit(this.outputPipelineTerminationNode);
        $this$getNodeStats_u24lambda_u2d1.addString("running", String.valueOf(this.running));
        Object object = this.localVideoSsrc;
        if (object == null || (object = ((Long)object).toString()) == null) {
            object = "null";
        }
        $this$getNodeStats_u24lambda_u2d1.addString("localVideoSsrc", (String)object);
        Object object2 = this.localAudioSsrc;
        if (object2 == null || (object2 = ((Long)object2).toString()) == null) {
            object2 = "null";
        }
        $this$getNodeStats_u24lambda_u2d1.addString("localAudioSsrc", (String)object2);
        $this$getNodeStats_u24lambda_u2d1.addJson("transportCcEngine", this.transportCcEngine.getStatistics().toJson());
        $this$getNodeStats_u24lambda_u2d1.addJson("Bandwidth Estimation", BandwidthEstimator.getStats$default(this.getBandwidthEstimator(), null, 1, null).toJson());
        return nodeStatsBlock;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void tearDown() {
        this.logger.info("Tearing down");
        new NodeTeardownVisitor().reverseVisit(this.outputPipelineTerminationNode);
        this.incomingPacketQueue.close();
        this.toggleablePcapWriter.disable();
    }

    public static final /* synthetic */ boolean access$handlePacket(RtpSenderImpl $this, PacketInfo packetInfo) {
        return $this.handlePacket(packetInfo);
    }

    public static final /* synthetic */ PacketHandler access$getOutgoingPacketHandler$p(RtpSenderImpl $this) {
        return $this.outgoingPacketHandler;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        Companion = new Companion(null);
        queueErrorCounter = new CountingErrorHandler();
        String string = "jmt.transceiver.send.queue-size";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        queueSize$delegate = new ConfigDelegate(supplier$iv);
        packetLossConfig = new PacketLossConfig("jmt.debug.packet-loss.outgoing");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/RtpSenderImpl$Companion;", "", "()V", "PACKET_QUEUE_ENTRY_EVENT", "", "PACKET_QUEUE_EXIT_EVENT", "packetLossConfig", "Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "queueSize", "", "getQueueSize", "()I", "queueSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        private final int getQueueSize() {
            return ((Number)queueSize$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "queueSize", "getQueueSize()I", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Features.values().length];
            nArray[Features.TRANSCEIVER_PCAP_DUMP.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            nArray[MediaType.VIDEO.ordinal()] = 1;
            nArray[MediaType.AUDIO.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

