/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.PcapWriter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.MacAddress;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0016\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eH\u0016R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00110\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0013\u001a\n \t*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jitsi/nlj/transform/node/PcapWriter;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "filePath", "", "(Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;)V", "handle", "Lorg/pcap4j/core/PcapHandle;", "kotlin.jvm.PlatformType", "getHandle", "()Lorg/pcap4j/core/PcapHandle;", "handle$delegate", "Lkotlin/Lazy;", "lazyHandle", "Lkotlin/Lazy;", "lazyWriter", "Lorg/pcap4j/core/PcapDumper;", "logger", "writer", "getWriter", "()Lorg/pcap4j/core/PcapDumper;", "writer$delegate", "close", "", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "Companion", "jitsi-media-transform"})
public final class PcapWriter
extends ObserverNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy<PcapHandle> lazyHandle;
    @NotNull
    private final Lazy handle$delegate;
    @NotNull
    private final Lazy<PcapDumper> lazyWriter;
    @NotNull
    private final Lazy writer$delegate;
    @NotNull
    private static final Inet4Address localhost;

    public PcapWriter(@NotNull Logger parentLogger, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        super("PCAP writer");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.handle$delegate = this.lazyHandle = LazyKt.lazy(lazyHandle.1.INSTANCE);
        this.writer$delegate = this.lazyWriter = LazyKt.lazy((Function0)new Function0<PcapDumper>(this, filePath){
            final /* synthetic */ PcapWriter this$0;
            final /* synthetic */ String $filePath;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final PcapDumper invoke() {
                void $this$cinfo$iv;
                Logger logger = PcapWriter.access$getLogger$p(this.this$0);
                String string = this.$filePath;
                boolean $i$f$cinfo = false;
                if ($this$cinfo$iv.isInfoEnabled()) {
                    void var5_4 = $this$cinfo$iv;
                    boolean bl = false;
                    var5_4.info("Pcap writer writing to file " + string);
                }
                return PcapWriter.access$getHandle(this.this$0).dumpOpen(this.$filePath);
            }
        });
    }

    public /* synthetic */ PcapWriter(Logger logger, String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = "/tmp/" + new Random().nextLong() + ".pcap}";
        }
        this(logger, (String)object);
    }

    private final PcapHandle getHandle() {
        Lazy lazy = this.handle$delegate;
        return (PcapHandle)lazy.getValue();
    }

    private final PcapDumper getWriter() {
        Lazy lazy = this.writer$delegate;
        return (PcapDumper)lazy.getValue();
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        UnknownPacket.Builder udpPayload = new UnknownPacket.Builder();
        byte[] subBuf = new byte[packetInfo.getPacket().length];
        System.arraycopy(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, subBuf, 0, packetInfo.getPacket().length);
        udpPayload.rawData(subBuf);
        UdpPacket.Builder udp = new UdpPacket.Builder().srcPort(new UdpPort((short)123, "blah")).dstPort(new UdpPort((short)456, "blah")).srcAddr(localhost).dstAddr(localhost).correctChecksumAtBuild(true).correctLengthAtBuild(true).payloadBuilder(udpPayload);
        IpV4Packet.Builder ipPacket = new IpV4Packet.Builder().srcAddr(localhost).dstAddr(localhost).protocol(IpNumber.UDP).version(IpVersion.IPV4).tos(IpV4Rfc1349Tos.newInstance((byte)0)).correctLengthAtBuild(true).payloadBuilder(udp);
        EthernetPacket eth = new EthernetPacket.Builder().srcAddr(MacAddress.ETHER_BROADCAST_ADDRESS).dstAddr(MacAddress.ETHER_BROADCAST_ADDRESS).type(EtherType.IPV4).paddingAtBuild(true).payloadBuilder(ipPacket).build();
        this.getWriter().dump(eth);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    public final void close() {
        if (this.lazyWriter.isInitialized() && this.getWriter().isOpen()) {
            this.getWriter().close();
        }
        if (this.lazyHandle.isInitialized() && this.getHandle().isOpen()) {
            this.getHandle().close();
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(PcapWriter $this) {
        return $this.logger;
    }

    public static final /* synthetic */ PcapHandle access$getHandle(PcapWriter $this) {
        return $this.getHandle();
    }

    static {
        InetAddress inetAddress = Inet4Address.getByName("127.0.0.1");
        if (inetAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.Inet4Address");
        }
        localhost = (Inet4Address)inetAddress;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/nlj/transform/node/PcapWriter$Companion;", "", "()V", "localhost", "Ljava/net/Inet4Address;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

