/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.MessageHandler;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0014J\u0018\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u001dH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "Lorg/jitsi/videobridge/message/MessageHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/utils/logging2/Logger;)V", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "incomingMessageQueue", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$MessageAndSource;", "isConnected", "", "()Z", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "close", "", "notifyTransportChannelConnected", "onMessage", "src", "", "msg", "", "sendMessage", "dst", "message", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "Companion", "EndpointMessageTransportEventHandler", "MessageAndSource", "jitsi-videobridge"})
public abstract class AbstractEndpointMessageTransport
extends MessageHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final PacketQueue<MessageAndSource> incomingMessageQueue;
    @NotNull
    public static final String INCOMING_MESSAGE_QUEUE_ID = "bridge-channel-message-incoming-queue";

    public AbstractEndpointMessageTransport(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Logger logger = parentLogger.createChildLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue(logger, "parentLogger.createChildLogger(javaClass.name)");
        this.logger = logger;
        this.incomingMessageQueue = new PacketQueue<MessageAndSource>(50, true, INCOMING_MESSAGE_QUEUE_ID, arg_0 -> AbstractEndpointMessageTransport.incomingMessageQueue$lambda-1(this, arg_0), TaskPools.IO_POOL, Clock.systemUTC());
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    public abstract boolean isConnected();

    protected void notifyTransportChannelConnected() {
    }

    public final void onMessage(@Nullable Object src, @NotNull String msg) {
        BridgeChannelMessage bridgeChannelMessage;
        Intrinsics.checkNotNullParameter(msg, "msg");
        try {
            bridgeChannelMessage = BridgeChannelMessage.Companion.parse(msg);
        }
        catch (IOException ioe) {
            this.logger.warn("Invalid message received (" + ioe.getMessage() + ": " + msg);
            return;
        }
        BridgeChannelMessage message = bridgeChannelMessage;
        this.logger.debug(() -> AbstractEndpointMessageTransport.onMessage$lambda-2(msg));
        this.incomingMessageQueue.add(new MessageAndSource(message, src));
    }

    protected void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
    }

    protected void sendMessage(@Nullable Object dst, @NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.logger.debug(() -> AbstractEndpointMessageTransport.sendMessage$lambda-3(message));
    }

    public void close() {
    }

    @NotNull
    public JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d4 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u2d4).put("received_counts", new JSONObject(this.getReceivedCounts()));
        return jSONObject;
    }

    private static final boolean incomingMessageQueue$lambda-1(AbstractEndpointMessageTransport this$0, MessageAndSource messageAndSource) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            BridgeChannelMessage bridgeChannelMessage = this$0.handleMessage(messageAndSource.getMessage());
            if (bridgeChannelMessage != null) {
                BridgeChannelMessage response2 = bridgeChannelMessage;
                boolean bl = false;
                this$0.sendMessage(messageAndSource.getSource(), response2);
            }
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to handle message: ", e);
        }
        return true;
    }

    private static final String onMessage$lambda-2(String $msg) {
        Intrinsics.checkNotNullParameter($msg, "$msg");
        return "RECV: " + $msg;
    }

    private static final String sendMessage$lambda-3(BridgeChannelMessage $message) {
        Intrinsics.checkNotNullParameter($message, "$message");
        return "SENT: " + $message.toJson();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;", "", "endpointMessageTransportConnected", "", "endpoint", "Lorg/jitsi/videobridge/AbstractEndpoint;", "jitsi-videobridge"})
    public static interface EndpointMessageTransportEventHandler {
        public void endpointMessageTransportConnected(@NotNull AbstractEndpoint var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$MessageAndSource;", "", "message", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "source", "(Lorg/jitsi/videobridge/message/BridgeChannelMessage;Ljava/lang/Object;)V", "getMessage", "()Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "getSource", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    private static final class MessageAndSource {
        @NotNull
        private final BridgeChannelMessage message;
        @Nullable
        private final Object source;

        public MessageAndSource(@NotNull BridgeChannelMessage message, @Nullable Object source) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.message = message;
            this.source = source;
        }

        @NotNull
        public final BridgeChannelMessage getMessage() {
            return this.message;
        }

        @Nullable
        public final Object getSource() {
            return this.source;
        }

        @NotNull
        public final BridgeChannelMessage component1() {
            return this.message;
        }

        @Nullable
        public final Object component2() {
            return this.source;
        }

        @NotNull
        public final MessageAndSource copy(@NotNull BridgeChannelMessage message, @Nullable Object source) {
            Intrinsics.checkNotNullParameter(message, "message");
            return new MessageAndSource(message, source);
        }

        public static /* synthetic */ MessageAndSource copy$default(MessageAndSource messageAndSource, BridgeChannelMessage bridgeChannelMessage, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                bridgeChannelMessage = messageAndSource.message;
            }
            if ((n & 2) != 0) {
                object = messageAndSource.source;
            }
            return messageAndSource.copy(bridgeChannelMessage, object);
        }

        @NotNull
        public String toString() {
            return "MessageAndSource(message=" + this.message + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + (this.source == null ? 0 : this.source.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageAndSource)) {
                return false;
            }
            MessageAndSource messageAndSource = (MessageAndSource)other;
            if (!Intrinsics.areEqual(this.message, messageAndSource.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.source, messageAndSource.source);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$Companion;", "", "()V", "INCOMING_MESSAGE_QUEUE_ID", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

