/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "", "initialState", "", "clock", "Ljava/time/Clock;", "(ZLjava/time/Clock;)V", "lock", "mostRecentStateChange", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "<set-?>", "state", "getState", "()Z", "totalTimeOff", "Ljava/time/Duration;", "totalTimeOn", "off", "", "on", "setState", "jitsi-videobridge"})
public final class BooleanStateTimeTracker {
    @NotNull
    private final Clock clock;
    @NotNull
    private Duration totalTimeOn;
    @NotNull
    private Duration totalTimeOff;
    private boolean state;
    private Instant mostRecentStateChange;
    @NotNull
    private final Object lock;

    public BooleanStateTimeTracker(boolean initialState, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        Duration duration = Duration.ofMillis(0L);
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(0)");
        this.totalTimeOn = duration;
        Duration duration2 = Duration.ofMillis(0L);
        Intrinsics.checkNotNullExpressionValue(duration2, "ofMillis(0)");
        this.totalTimeOff = duration2;
        this.state = initialState;
        this.mostRecentStateChange = this.clock.instant();
        this.lock = new Object();
    }

    public /* synthetic */ BooleanStateTimeTracker(boolean bl, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(bl, clock);
    }

    public final boolean getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Duration totalTimeOn() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!this.state) break block4;
                Duration duration = this.totalTimeOn.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue(duration, "totalTimeOn + Duration.b\u2026eChange, clock.instant())");
                Duration duration2 = duration;
                return duration2;
            }
            Duration duration = this.totalTimeOn;
            return duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Duration totalTimeOff() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.state) break block4;
                Duration duration = this.totalTimeOff.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue(duration, "totalTimeOff + Duration.\u2026eChange, clock.instant())");
                Duration duration2 = duration;
                return duration2;
            }
            Duration duration = this.totalTimeOff;
            return duration;
        }
    }

    public final void setState(boolean state) {
        if (state) {
            this.on();
        } else {
            this.off();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void on() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.state) {
                this.state = true;
                Duration duration = this.totalTimeOff.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue(duration, "totalTimeOff += Duration\u2026eChange, clock.instant())");
                this.totalTimeOff = duration;
                this.mostRecentStateChange = this.clock.instant();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void off() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.state) {
                this.state = false;
                Duration duration = this.totalTimeOn.plus(Duration.between(this.mostRecentStateChange, this.clock.instant()));
                Intrinsics.checkNotNullExpressionValue(duration, "totalTimeOn += Duration.\u2026eChange, clock.instant())");
                this.totalTimeOn = duration;
                this.mostRecentStateChange = this.clock.instant();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public BooleanStateTimeTracker() {
        this(false, null, 3, null);
    }
}

