/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5Client {
    private static final Logger LOGGER = Logger.getLogger(Socks5Client.class.getName());
    protected Bytestream.StreamHost streamHost;
    protected String digest;

    public Socks5Client(Bytestream.StreamHost streamHost, String digest) {
        this.streamHost = streamHost;
        this.digest = digest;
    }

    public Socket getSocket(int timeout2) throws IOException, InterruptedException, TimeoutException, XMPPException, SmackException.SmackMessageException, SmackException.NotConnectedException, SmackException.NoResponseException {
        FutureTask<Socket> futureTask = new FutureTask<Socket>(new Callable<Socket>(){

            @Override
            public Socket call() throws IOException, SmackException.SmackMessageException {
                Socket socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress(Socks5Client.this.streamHost.getAddress().asInetAddress(), Socks5Client.this.streamHost.getPort());
                socket.connect(socketAddress);
                try {
                    Socks5Client.this.establish(socket);
                }
                catch (SmackException.SmackMessageException e) {
                    if (!socket.isClosed()) {
                        CloseableUtil.maybeClose(socket, LOGGER);
                    }
                    throw e;
                }
                return socket;
            }
        });
        Async.go(futureTask, "SOCKS5 client connecting to " + this.streamHost);
        try {
            return futureTask.get(timeout2, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new IOException("ExecutionException while SOCKS5 client attempting to connect to " + this.streamHost, e);
        }
    }

    protected void establish(Socket socket) throws IOException, SmackException.SmackMessageException {
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        byte[] cmd = new byte[]{5, 1, 0};
        out.write(cmd);
        out.flush();
        byte[] response2 = new byte[2];
        in.readFully(response2);
        if (response2[0] != 5 || response2[1] != 0) {
            throw new SmackException.SmackMessageException("Remote SOCKS5 server responded with unexpected version: " + response2[0] + ' ' + response2[1] + ". Should be 0x05 0x00.");
        }
        byte[] connectionRequest = this.createSocks5ConnectRequest();
        out.write(connectionRequest);
        out.flush();
        byte[] connectionResponse = Socks5Utils.receiveSocks5Message(in);
        connectionRequest[1] = 0;
        if (!Arrays.equals(connectionRequest, connectionResponse)) {
            throw new SmackException.SmackMessageException("Connection request does not equal connection response. Response: " + Arrays.toString(connectionResponse) + ". Request: " + Arrays.toString(connectionRequest));
        }
    }

    private byte[] createSocks5ConnectRequest() {
        byte[] addr = this.digest.getBytes(StandardCharsets.UTF_8);
        byte[] data2 = new byte[7 + addr.length];
        data2[0] = 5;
        data2[1] = 1;
        data2[2] = 0;
        data2[3] = 3;
        data2[4] = (byte)addr.length;
        System.arraycopy(addr, 0, data2, 5, addr.length);
        data2[data2.length - 2] = 0;
        data2[data2.length - 1] = 0;
        return data2;
    }
}

