/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.Site;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class YieldInstr
extends TwoOperandResultBaseInstr
implements FixedArityInstr,
Site {
    public final boolean unwrapArray;
    private final int flags;
    private long callSiteId;

    public YieldInstr(Variable result2, Operand block, Operand arg2, int flags2, boolean unwrapArray) {
        super(Operation.YIELD, result2, block, arg2 == null ? UndefinedValue.UNDEFINED : arg2);
        assert (result2 != null) : "YieldInstr result is null";
        this.flags = flags2;
        this.unwrapArray = unwrapArray;
        this.callSiteId = CallBase.callSiteCounter++;
    }

    public Operand getBlockArg() {
        return this.getOperand1();
    }

    public Operand getYieldArg() {
        return this.getOperand2();
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new YieldInstr(ii.getRenamedVariable(this.result), this.getBlockArg().cloneForInlining(ii), this.getYieldArg().cloneForInlining(ii), this.flags, this.unwrapArray);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"flags: " + this.flags + "unwrap: " + this.unwrapArray};
    }

    public boolean isUnwrapArray() {
        return this.unwrapArray;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getBlockArg());
        e.encode(this.getYieldArg());
        e.encode(this.flags);
        e.encode(this.isUnwrapArray());
    }

    public static YieldInstr decode(IRReaderDecoder d) {
        return new YieldInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand(), d.decodeInt(), d.decodeBoolean());
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Block blk = (Block)this.getBlockArg().retrieve(context, self2, currScope, currDynScope, temp);
        if (this.getYieldArg() == UndefinedValue.UNDEFINED) {
            IRRuntimeHelpers.setCallInfo(context, this.flags);
            return IRRuntimeHelpers.yieldSpecific(context, blk);
        }
        Operand yieldOp = this.getYieldArg();
        if (this.unwrapArray && yieldOp instanceof Array && ((Array)yieldOp).size() > 1) {
            IRubyObject[] args2 = ((Array)yieldOp).retrieveArrayElts(context, self2, currScope, currDynScope, temp);
            IRRuntimeHelpers.setCallInfo(context, this.flags);
            return IRRuntimeHelpers.yieldValues(context, blk, args2);
        }
        IRubyObject yieldVal = (IRubyObject)yieldOp.retrieve(context, self2, currScope, currDynScope, temp);
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        return IRRuntimeHelpers.yield(context, blk, yieldVal, this.unwrapArray);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.YieldInstr(this);
    }

    @Override
    public long getCallSiteId() {
        return this.callSiteId;
    }

    @Override
    public void setCallSiteId(long callSiteId) {
        this.callSiteId = callSiteId;
    }
}

