/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.standalone;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class BeanPropertyExtraction {
    public static final String IS_REGEX = "is([^ ]+)";
    public static final String GET_REGEX = "get([^ ]+)";
    public static final Pattern IS_PATTERN = Pattern.compile("is([^ ]+)");
    public static final Pattern GET_PATTERN = Pattern.compile("get([^ ]+)");

    private BeanPropertyExtraction() {
    }

    static Map<String, Object> extractProperties(Object object) {
        Map<String, Method> methodMap = BeanPropertyExtraction.createPropertyToMethodMap(object);
        return BeanPropertyExtraction.retrieveValues(object, methodMap);
    }

    private static Map<String, Method> createPropertyToMethodMap(Object object) {
        Method[] methods;
        Class<?> beanClass = object.getClass();
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (Method method : methods = beanClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE) || method.getDeclaringClass().equals(Object.class)) continue;
            String name = method.getName();
            String propertyName = BeanPropertyExtraction.getPropertyName(name, GET_PATTERN);
            if (propertyName == null) {
                propertyName = BeanPropertyExtraction.getPropertyName(name, IS_PATTERN);
            }
            if (propertyName == null) continue;
            propertyName = BeanPropertyExtraction.decapitalizePropertyName(propertyName);
            methodMap.put(propertyName, method);
        }
        return methodMap;
    }

    private static String decapitalizePropertyName(String propertyName) {
        String first = propertyName.substring(0, 1);
        String last = propertyName.substring(1);
        return first.toLowerCase() + last;
    }

    private static Map<String, Object> retrieveValues(Object object, Map<String, Method> methodMap) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, Method> entry : methodMap.entrySet()) {
            try {
                Object value = entry.getValue().invoke(object, new Object[0]);
                if (value == null) continue;
                fields.put(entry.getKey(), value);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
        return fields;
    }

    private static String getPropertyName(String name, Pattern pattern) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            return matcher.toMatchResult().group(1);
        }
        return null;
    }
}

