/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.KcEnvConfigSource;
import org.keycloak.quarkus.runtime.configuration.KeycloakPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;

public class KeycloakConfigSourceProvider
implements ConfigSourceProvider,
ConfigBuilder {
    private static final List<ConfigSource> CONFIG_SOURCES = new ArrayList<ConfigSource>();

    private static void initializeSources() {
        String profile = Environment.getProfile();
        if (profile != null) {
            System.setProperty("quarkus.profile", profile);
        }
        CONFIG_SOURCES.add((ConfigSource)new ConfigArgsConfigSource());
        CONFIG_SOURCES.add((ConfigSource)new KcEnvConfigSource());
        CONFIG_SOURCES.addAll((Collection<ConfigSource>)new QuarkusPropertiesConfigSource().getConfigSources(Thread.currentThread().getContextClassLoader()));
        CONFIG_SOURCES.add((ConfigSource)PersistedConfigSource.getInstance());
        CONFIG_SOURCES.addAll((Collection<ConfigSource>)new KeycloakPropertiesConfigSource.InFileSystem().getConfigSources(Thread.currentThread().getContextClassLoader()));
        CONFIG_SOURCES.addAll((Collection<ConfigSource>)new KeycloakPropertiesConfigSource.InClassPath().getConfigSources(Thread.currentThread().getContextClassLoader()));
    }

    public static void reload() {
        CONFIG_SOURCES.clear();
        KeycloakConfigSourceProvider.initializeSources();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (Environment.isTestLaunchMode()) {
            KeycloakConfigSourceProvider.reload();
        }
        return CONFIG_SOURCES;
    }

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        return builder.withSources(CONFIG_SOURCES);
    }

    static {
        KeycloakConfigSourceProvider.initializeSources();
    }
}

