/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.driver.PhysicalConnection;

class ConnectionTraceContext
implements TraceEventListener.TraceContext {
    private PhysicalConnection physicalConnection;

    protected ConnectionTraceContext(PhysicalConnection physicalConnection) {
        this.physicalConnection = physicalConnection;
    }

    @Override
    public String getConnectionId() {
        this.throwIfIllegalState();
        try {
            return this.physicalConnection.getNetConnectionId();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String databaseOperation() {
        this.throwIfIllegalState();
        return this.physicalConnection.getExecutingRpcFunctionCodeDescription();
    }

    @Override
    public String originalSqlText() {
        this.throwIfIllegalState();
        if (this.physicalConnection.statements != null && this.physicalConnection.statements.sqlObject != null) {
            return this.physicalConnection.statements.sqlObject.getOriginalSql();
        }
        return null;
    }

    @Override
    public String actualSqlText() {
        this.throwIfIllegalState();
        if (this.physicalConnection.statements != null && this.physicalConnection.statements.sqlObject != null) {
            return this.physicalConnection.statements.sqlObject.actualSql;
        }
        return null;
    }

    @Override
    public String user() {
        this.throwIfIllegalState();
        try {
            return this.physicalConnection.getUserName();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String tenant() {
        this.throwIfIllegalState();
        return this.physicalConnection.getTenantName();
    }

    @Override
    public String getSqlId() {
        this.throwIfIllegalState();
        if (this.physicalConnection.statements == null) {
            return null;
        }
        try {
            return this.physicalConnection.statements.getSqlId();
        }
        catch (SQLException sqlException) {
            return null;
        }
    }

    @Override
    public Boolean isCompletedExceptionally() {
        this.throwIfIllegalState();
        return this.physicalConnection.isLastRpcCompletedExceptionally();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.throwIfIllegalState();
        this.physicalConnection.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfIllegalState();
        return this.physicalConnection.getClientInfo(name);
    }

    private void throwIfIllegalState() {
        if (this.physicalConnection == null) {
            throw new IllegalStateException();
        }
    }

    protected void reset() {
        this.physicalConnection = null;
    }
}

