/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.ForwardedServerRequestWrapper;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.net.Inet;

public class ForwardedProxyHandler
implements Handler<HttpServerRequest> {
    private static final Logger LOGGER = Logger.getLogger((String)ForwardedProxyHandler.class.getName());
    private final TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder;
    private final Supplier<Vertx> vertx;
    private final Handler<HttpServerRequest> delegate;
    private final ForwardingProxyOptions forwardingProxyOptions;

    public ForwardedProxyHandler(TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder, Supplier<Vertx> vertx, Handler<HttpServerRequest> delegate, ForwardingProxyOptions forwardingProxyOptions) {
        this.proxyCheckBuilder = proxyCheckBuilder;
        this.vertx = vertx;
        this.delegate = delegate;
        this.forwardingProxyOptions = forwardingProxyOptions;
    }

    public void handle(HttpServerRequest event) {
        if (event.remoteAddress() == null) {
            LOGGER.debug((Object)"Client address is not available, 'Forwarded' and 'X-Forwarded' headers are going to be ignored");
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        } else if (event.remoteAddress().isDomainSocket()) {
            LOGGER.debug((Object)"Domain socket are not supported, 'Forwarded' and 'X-Forwarded' headers are going to be ignored");
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        } else if (this.proxyCheckBuilder.hasHostNames()) {
            this.lookupHostNamesAndHandleRequest(event, this.proxyCheckBuilder.getHostNameToPort().entrySet().iterator(), this.proxyCheckBuilder, this.vertx.get().createDnsClient());
        } else {
            this.resolveProxyIpAndHandleRequest(event, this.proxyCheckBuilder);
        }
    }

    private void lookupHostNamesAndHandleRequest(final HttpServerRequest event, final Iterator<Map.Entry<String, Integer>> iterator, final TrustedProxyCheck.TrustedProxyCheckBuilder builder, final DnsClient dnsClient) {
        if (iterator.hasNext()) {
            final Map.Entry<String, Integer> entry = iterator.next();
            final String hostName = entry.getKey();
            dnsClient.lookup(hostName, (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> stringAsyncResult) {
                    if (stringAsyncResult.succeeded() && stringAsyncResult.result() != null) {
                        InetAddress trustedIP = Inet.parseInetAddress((String)((String)stringAsyncResult.result()));
                        if (trustedIP != null) {
                            ForwardedProxyHandler.this.lookupHostNamesAndHandleRequest(event, iterator, builder.withTrustedIP(trustedIP, (Integer)entry.getValue()), dnsClient);
                        } else {
                            ForwardedProxyHandler.logInvalidIpAddress(hostName);
                            ForwardedProxyHandler.this.lookupHostNamesAndHandleRequest(event, iterator, builder, dnsClient);
                        }
                    } else {
                        ForwardedProxyHandler.logDnsLookupFailure(hostName);
                        ForwardedProxyHandler.this.lookupHostNamesAndHandleRequest(event, iterator, builder, dnsClient);
                    }
                }
            });
        } else if (builder.hasProxyChecks()) {
            this.resolveProxyIpAndHandleRequest(event, builder);
        } else {
            this.handleForwardedServerRequest(event, TrustedProxyCheck.denyAll());
        }
    }

    private void resolveProxyIpAndHandleRequest(final HttpServerRequest event, final TrustedProxyCheck.TrustedProxyCheckBuilder builder) {
        InetAddress proxyIP = ((SocketAddressImpl)event.remoteAddress()).ipAddress();
        if (proxyIP == null) {
            proxyIP = Inet.parseInetAddress((String)event.remoteAddress().host());
        }
        if (proxyIP == null) {
            final String hostName = Objects.requireNonNull(event.remoteAddress().hostName());
            this.vertx.get().createDnsClient().lookup(hostName, (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> stringAsyncResult) {
                    TrustedProxyCheck proxyCheck;
                    if (stringAsyncResult.succeeded()) {
                        InetAddress proxyIP = Inet.parseInetAddress((String)((String)stringAsyncResult.result()));
                        if (proxyIP != null) {
                            proxyCheck = builder.build(proxyIP, event.remoteAddress().port());
                        } else {
                            ForwardedProxyHandler.logInvalidIpAddress(hostName);
                            proxyCheck = TrustedProxyCheck.denyAll();
                        }
                    } else {
                        ForwardedProxyHandler.logDnsLookupFailure(hostName);
                        proxyCheck = TrustedProxyCheck.denyAll();
                    }
                    ForwardedProxyHandler.this.handleForwardedServerRequest(event, proxyCheck);
                }
            });
        } else {
            TrustedProxyCheck proxyCheck = builder.build(proxyIP, event.remoteAddress().port());
            this.handleForwardedServerRequest(event, proxyCheck);
        }
    }

    private void handleForwardedServerRequest(HttpServerRequest event, TrustedProxyCheck proxyCheck) {
        this.delegate.handle((Object)new ForwardedServerRequestWrapper(event, this.forwardingProxyOptions, proxyCheck));
    }

    private static void logInvalidIpAddress(String hostName) {
        LOGGER.debugf("Illegal state - DNS server returned invalid IP address for hostname '%s'", (Object)hostName);
    }

    private static void logDnsLookupFailure(String hostName) {
        LOGGER.debugf("Can't resolve proxy IP address from '%s'", (Object)hostName);
    }
}

