/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.xhtml;

import java.io.IOException;
import java.net.URL;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.xhtml.XhtmlResourceFactoryModule;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.util.NullOutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XhtmlInputDriver {
    public static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private InputFeed feed;

    public XhtmlInputDriver(InputFeed inputFeed) {
        this.feed = inputFeed;
    }

    public void processDomTree(Document document) throws InputFeedException {
        Element element = document.getDocumentElement();
        if ("html".equalsIgnoreCase(element.getTagName())) {
            this.processFullDocument(element);
        } else {
            this.feed.startDocument();
            this.processBodyElement(element);
            this.feed.endDocument();
        }
    }

    private void processFullDocument(Element element) throws InputFeedException {
        this.feed.startDocument();
        this.feed.startMetaInfo();
        NodeList nodeList = element.getElementsByTagName("head");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("title");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                this.feed.addDocumentAttribute("title", this.getCData(element3));
            }
            NodeList nodeList3 = element2.getChildNodes();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Element element4;
                Node node = nodeList3.item(j);
                if (!(node instanceof Element) || "title".equalsIgnoreCase((element4 = (Element)nodeList3.item(j)).getTagName())) continue;
                this.feed.startMetaNode();
                this.feed.setMetaNodeAttribute("type", element4.getTagName());
                NamedNodeMap namedNodeMap = element4.getAttributes();
                for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                    Attr attr = (Attr)namedNodeMap.item(k);
                    this.feed.setMetaNodeAttribute(attr.getName(), attr.getValue());
                }
                this.feed.setMetaNodeAttribute("#pcdata", this.getCData(element4));
                this.feed.endMetaNode();
            }
        }
        this.feed.endMetaInfo();
        this.processBodyElement(element);
        this.feed.endDocument();
    }

    private String getCData(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            stringBuffer.append(text.getData());
        }
        return stringBuffer.toString();
    }

    private void processBodyElement(Element element) throws InputFeedException {
        this.feed.startElement(NAMESPACE, element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            this.feed.setAttribute(NAMESPACE, attr.getName(), attr.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            if (node2 instanceof Element) {
                node = (Element)node2;
                this.processBodyElement((Element)node);
                continue;
            }
            if (!(node2 instanceof Text)) continue;
            node = (Text)node2;
            this.feed.addContent(node.getData());
        }
        this.feed.endElement();
    }

    public static void main(String[] stringArray) throws IOException, NormalizationException {
        LibLayoutBoot.getInstance().start();
        NullOutputStream nullOutputStream = new NullOutputStream();
        URL uRL = new URL("file:///home/src/jfreereport/head/liblayout/styletest/simple.html");
        XhtmlResourceFactoryModule xhtmlResourceFactoryModule = new XhtmlResourceFactoryModule();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            DefaultLayoutProcess defaultLayoutProcess = new DefaultLayoutProcess(new StreamingHtmlOutputProcessor(LibLayoutBoot.getInstance().getGlobalConfig()));
            XhtmlInputDriver xhtmlInputDriver = new XhtmlInputDriver(defaultLayoutProcess.getInputFeed());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Done!: " + (l2 - l));
    }
}

