%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/other/grob-array-list.ly"
\sourcefileline 0
\version "2.23.4"

\header {
  texidoc = "Conversions are possible between grob arrays and
grob lists."
}

{
  \override NoteColumn.after-line-breaking =
    #(lambda (grob)
       (let* ((note-heads-array (ly:grob-object grob 'note-heads))
              (note-heads-list (ly:grob-array->list note-heads-array)))
         (if (not (equal? note-heads-list
                          (ly:grob-array->list
                            (ly:grob-list->grob-array
                              note-heads-list))))
             (ly:error "Test failed: conversion from list to array \
and back changes value."))))
  <c d e f g>
}

%% Test robustness

#(ly:set-option 'warning-as-error)

#(ly:expect-warning (G_ "ly:grob-list->grob-array expected a list"))
#(ly:grob-list->grob-array 42)

#(ly:expect-warning (G_ "ly:grob-list->grob-array encountered a non-grob object"))
#(ly:grob-list->grob-array '(42))



% ****************************************************************
% end ly snippet
% ****************************************************************
