%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/break-alignment-anchor-average-clamp.ly"
\sourcefileline 0
\version "2.23.14"

\header {
  texidoc = "In this case, the compound time signature has a CENTER
(0) anchor point and the 1/1 time signature has a LEFT (1) anchor
point.  The midpoint of these is 0.75, but it is not used for the
``average'' anchor point of the group because it would fall outside
the range of anchor points that the isolated time signatures would
choose.  Instead, the average anchor point is the closer extreme of
that range, which is the center of the compound time signature.  The
arrow should point there."
}

\layout {
  \context {
    \Score
    %% Point rehearsal marks at the right side of time signatures by
    %% default.
    \override TextMark.break-align-symbols = #'(time-signature)
    \override TextMark.self-alignment-X = #CENTER
    \override TimeSignature.break-align-anchor-alignment = #RIGHT
  }

  \enablePolymeter
}

\fixed c' <<
  \new Staff \with { % here, point at the right side (almost)
    \override TimeSignature.break-align-anchor-alignment = #CENTER
  } {
    \compoundMeter 1,2,3,1 \textMark "↓"
    c1 \bar "|"
  }
  \new Staff {
    \time 1/1
    c1
  }
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
