/*
 * Decompiled with CFR 0.152.
 */
package hitimes;

import hitimes.Hitimes;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Hitimes::Interval"})
public class HitimesInterval
extends RubyObject {
    private static final long INSTANT_NOT_SET = Long.MIN_VALUE;
    private static final double DURATION_NOT_SET = Double.NaN;
    public static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new HitimesInterval(ruby, rubyClass);
        }
    };
    private long start_instant = Long.MIN_VALUE;
    private long stop_instant = Long.MIN_VALUE;
    private double duration = Double.NaN;

    public HitimesInterval(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public HitimesInterval(Ruby ruby, RubyClass rubyClass, long l) {
        super(ruby, rubyClass);
        this.start_instant = l;
    }

    @JRubyMethod(name={"duration"}, alias={"length", "to_f", "to_seconds"})
    public IRubyObject duration() {
        if (Long.MIN_VALUE == this.start_instant) {
            throw Hitimes.newHitimesError(this.getRuntime(), "Attempt to report a duration on an interval that has not started");
        }
        if (Long.MIN_VALUE == this.stop_instant) {
            double d = (double)(System.nanoTime() - this.start_instant) / 1.0E9;
            return this.getRuntime().newFloat(d);
        }
        if (Double.NaN == this.duration) {
            this.duration = (double)(this.stop_instant - this.start_instant) / 1.0E9;
        }
        return this.getRuntime().newFloat(this.duration);
    }

    @JRubyMethod(name={"duration_so_far"})
    public IRubyObject duration_so_far() {
        RubyBoolean rubyBoolean = this.getRuntime().getFalse();
        if (Long.MIN_VALUE == this.start_instant) {
            return rubyBoolean;
        }
        if (Long.MIN_VALUE == this.stop_instant) {
            double d = (double)(System.nanoTime() - this.start_instant) / 1.0E9;
            return this.getRuntime().newFloat(d);
        }
        return rubyBoolean;
    }

    @JRubyMethod(name={"started?"})
    public IRubyObject is_started() {
        if (Long.MIN_VALUE == this.start_instant) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"running?"})
    public IRubyObject is_running() {
        if (Long.MIN_VALUE != this.start_instant && Long.MIN_VALUE == this.stop_instant) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"stopped?"})
    public IRubyObject is_stopped() {
        if (Long.MIN_VALUE == this.stop_instant) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"start_instant"})
    public IRubyObject start_instant() {
        return this.getRuntime().newFixnum(this.start_instant);
    }

    @JRubyMethod(name={"stop_instant"})
    public IRubyObject stop_instant() {
        return this.getRuntime().newFixnum(this.stop_instant);
    }

    @JRubyMethod(name={"start"})
    public IRubyObject start() {
        if (Long.MIN_VALUE == this.start_instant) {
            this.start_instant = System.nanoTime();
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"stop"})
    public IRubyObject stop() {
        if (Long.MIN_VALUE == this.start_instant) {
            throw Hitimes.newHitimesError(this.getRuntime(), "Attempt to stop an interval that has not started");
        }
        if (Long.MIN_VALUE == this.stop_instant) {
            this.stop_instant = System.nanoTime();
            this.duration = (double)(this.stop_instant - this.start_instant) / 1.0E9;
            return this.getRuntime().newFloat(this.duration);
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"split"})
    public IRubyObject split() {
        this.stop();
        return new HitimesInterval(this.getRuntime(), Hitimes.hitimesIntervalClass, this.stop_instant);
    }

    @JRubyMethod(name={"now"}, module=true)
    public static IRubyObject now(IRubyObject iRubyObject) {
        return new HitimesInterval(iRubyObject.getRuntime(), Hitimes.hitimesIntervalClass, System.nanoTime());
    }

    @JRubyMethod(name={"measure"}, module=true, frame=true)
    public static IRubyObject measure(IRubyObject iRubyObject, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        if (block.isGiven()) {
            IRubyObject iRubyObject2 = ruby.getNil();
            ThreadContext threadContext = ruby.getCurrentContext();
            HitimesInterval hitimesInterval = new HitimesInterval(ruby, Hitimes.hitimesIntervalClass);
            hitimesInterval.start();
            block.yield(threadContext, iRubyObject2);
            hitimesInterval.stop();
            return hitimesInterval.duration();
        }
        throw Hitimes.newHitimesError(ruby, "No block given to Interval.measure");
    }
}

