/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputPoseActionData_t")
public class InputPoseActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;
    public static final int POSE;

    public InputPoseActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputPoseActionData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputPoseActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputPoseActionData.nactiveOrigin(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose pose() {
        return InputPoseActionData.npose(this.address());
    }

    public static InputPoseActionData malloc() {
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static InputPoseActionData calloc() {
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static InputPoseActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static InputPoseActionData create(long address) {
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)address);
    }

    @Nullable
    public static InputPoseActionData createSafe(long address) {
        return address == 0L ? null : (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)InputPoseActionData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputPoseActionData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)InputPoseActionData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static InputPoseActionData mallocStack() {
        return InputPoseActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputPoseActionData callocStack() {
        return InputPoseActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputPoseActionData mallocStack(MemoryStack stack) {
        return InputPoseActionData.malloc(stack);
    }

    @Deprecated
    public static InputPoseActionData callocStack(MemoryStack stack) {
        return InputPoseActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputPoseActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputPoseActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputPoseActionData.calloc(capacity, stack);
    }

    public static InputPoseActionData malloc(MemoryStack stack) {
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputPoseActionData calloc(MemoryStack stack) {
        return (InputPoseActionData)InputPoseActionData.wrap(InputPoseActionData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)InputPoseActionData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static boolean nbActive(long struct) {
        return UNSAFE.getByte(null, struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACTIVEORIGIN);
    }

    public static TrackedDevicePose npose(long struct) {
        return TrackedDevicePose.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = InputPoseActionData.__struct((Struct.Member[])new Struct.Member[]{InputPoseActionData.__member((int)1), InputPoseActionData.__member((int)8), InputPoseActionData.__member((int)TrackedDevicePose.SIZEOF, (int)TrackedDevicePose.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
        POSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<InputPoseActionData, Buffer>
    implements NativeResource {
        private static final InputPoseActionData ELEMENT_FACTORY = InputPoseActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected InputPoseActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputPoseActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputPoseActionData.nactiveOrigin(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose pose() {
            return InputPoseActionData.npose(this.address());
        }
    }
}

