/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.CreateInteractionRequest;
import org.opensearch.ml.memory.action.conversation.CreateInteractionResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class CreateInteractionTransportAction
extends HandledTransportAction<CreateInteractionRequest, CreateInteractionResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(CreateInteractionTransportAction.class);
    private ConversationalMemoryHandler cmHandler;
    private Client client;
    private volatile boolean featureIsEnabled;

    @Inject
    public CreateInteractionTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/interaction/create", transportService, actionFilters, CreateInteractionRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, CreateInteractionRequest request, ActionListener<CreateInteractionResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new OpenSearchException("The experimental Conversation Memory feature is not enabled. To enable, please update the setting " + ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.getKey(), new Object[0]));
            return;
        }
        String cid = request.getConversationId();
        String inp = request.getInput();
        String rsp = request.getResponse();
        String ogn = request.getOrigin();
        String prompt = request.getPromptTemplate();
        String additionalInfo = request.getAdditionalInfo();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListener.wrap(iid -> internalListener.onResponse((Object)new CreateInteractionResponse((String)iid)), e -> internalListener.onFailure(e));
            this.cmHandler.createInteraction(cid, inp, prompt, rsp, ogn, additionalInfo, (ActionListener<String>)al);
        }
        catch (Exception e2) {
            log.error("Failed to create interaction for conversation " + cid, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

