/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.PaddingStackBatchifier;

public final class SimplePaddingStackBatchifier
implements Batchifier {
    private float padding;

    public SimplePaddingStackBatchifier(float padding) {
        this.padding = padding;
    }

    public SimplePaddingStackBatchifier() {
        this(0.0f);
    }

    @Override
    public NDList batchify(NDList[] inputs) {
        int numArrays = inputs[0].size();
        for (int i = 0; i < numArrays; ++i) {
            int axes = ((NDArray)inputs[0].get(i)).getShape().dimension();
            for (int j = 0; j < axes; ++j) {
                long maxSize = PaddingStackBatchifier.findMaxSize(inputs, i, j);
                NDManager manager = inputs[0].getManager();
                NDArray padArray = manager.create(this.padding);
                PaddingStackBatchifier.padArrays(inputs, i, j, padArray, maxSize);
            }
        }
        return Batchifier.STACK.batchify(inputs);
    }

    @Override
    public NDList[] unbatchify(NDList inputs) {
        return Batchifier.STACK.unbatchify(inputs);
    }

    @Override
    public NDList[] split(NDList list, int numOfSlices, boolean evenSplit) {
        return Batchifier.STACK.split(list, numOfSlices, evenSplit);
    }
}

