/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.exceptions.ConcurrentModificationException;
import org.opensearch.geospatial.exceptions.ResourceInUseException;
import org.opensearch.geospatial.ip2geo.action.DeleteDatasourceRequest;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoLockService;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.dao.Ip2GeoProcessorDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.ingest.IngestService;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class DeleteDatasourceTransportAction
extends HandledTransportAction<DeleteDatasourceRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteDatasourceTransportAction.class);
    private static final long LOCK_DURATION_IN_SECONDS = 300L;
    private final Ip2GeoLockService lockService;
    private final IngestService ingestService;
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;
    private final Ip2GeoProcessorDao ip2GeoProcessorDao;
    private final ThreadPool threadPool;

    @Inject
    public DeleteDatasourceTransportAction(TransportService transportService, ActionFilters actionFilters, Ip2GeoLockService lockService, IngestService ingestService, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao, Ip2GeoProcessorDao ip2GeoProcessorDao, ThreadPool threadPool) {
        super("cluster:admin/geospatial/datasource/delete", transportService, actionFilters, DeleteDatasourceRequest::new);
        this.lockService = lockService;
        this.ingestService = ingestService;
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
        this.ip2GeoProcessorDao = ip2GeoProcessorDao;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, DeleteDatasourceRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.lockService.acquireLock(request.getName(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> {
            if (lock == null) {
                listener.onFailure((Exception)((Object)new ConcurrentModificationException("another processor is holding a lock on the resource. Try again later", new Object[0])));
                return;
            }
            try {
                this.threadPool.generic().submit(() -> {
                    try {
                        this.deleteDatasource(request.getName());
                        this.lockService.releaseLock((LockModel)lock);
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                    catch (Exception e) {
                        this.lockService.releaseLock((LockModel)lock);
                        listener.onFailure(e);
                    }
                });
            }
            catch (Exception e) {
                this.lockService.releaseLock((LockModel)lock);
                listener.onFailure(e);
            }
        }, exception -> listener.onFailure(exception)));
    }

    @VisibleForTesting
    protected void deleteDatasource(String datasourceName) throws IOException {
        Datasource datasource = this.datasourceDao.getDatasource(datasourceName);
        if (datasource == null) {
            throw new ResourceNotFoundException("no such datasource exist", new Object[0]);
        }
        DatasourceState previousState = datasource.getState();
        this.setDatasourceStateAsDeleting(datasource);
        try {
            this.geoIpDataDao.deleteIp2GeoDataIndex(datasource.getIndices());
        }
        catch (Exception e) {
            if (!previousState.equals((Object)datasource.getState())) {
                datasource.setState(previousState);
                this.datasourceDao.updateDatasource(datasource);
            }
            throw e;
        }
        this.datasourceDao.deleteDatasource(datasource);
    }

    private void setDatasourceStateAsDeleting(Datasource datasource) {
        if (!this.ip2GeoProcessorDao.getProcessors(datasource.getName()).isEmpty()) {
            throw new ResourceInUseException("datasource is being used by one of processors", new Object[0]);
        }
        DatasourceState previousState = datasource.getState();
        datasource.setState(DatasourceState.DELETING);
        this.datasourceDao.updateDatasource(datasource);
        if (!this.ip2GeoProcessorDao.getProcessors(datasource.getName()).isEmpty()) {
            datasource.setState(previousState);
            this.datasourceDao.updateDatasource(datasource);
            throw new ResourceInUseException("datasource is being used by one of processors", new Object[0]);
        }
    }
}

