/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.model;

import java.time.Instant;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/notifications/model/DocMetadata;", "Lorg/opensearch/core/xcontent/ToXContent;", "lastUpdateTime", "Ljava/time/Instant;", "createdTime", "access", "", "", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/util/List;)V", "getAccess", "()Ljava/util/List;", "getCreatedTime", "()Ljava/time/Instant;", "getLastUpdateTime", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "Companion", "opensearch-notifications"})
public final class DocMetadata
implements ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant lastUpdateTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final List<String> access;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DocMetadata.class);
    @NotNull
    public static final String METADATA_TAG = "metadata";
    @NotNull
    public static final String ACCESS_LIST_TAG = "access";

    public DocMetadata(@NotNull Instant lastUpdateTime, @NotNull Instant createdTime, @NotNull List<String> access) {
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter(access, (String)ACCESS_LIST_TAG);
        this.lastUpdateTime = lastUpdateTime;
        this.createdTime = createdTime;
        this.access = access;
    }

    @NotNull
    public final Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final List<String> getAccess() {
        return this.access;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        XContentBuilder xContentBuilder2 = xContentBuilder.startObject().field("last_updated_time_ms", this.lastUpdateTime.toEpochMilli()).field("created_time_ms", this.createdTime.toEpochMilli()).field(ACCESS_LIST_TAG, (Iterable)this.access).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder!!.startObject()\n\u2026\n            .endObject()");
        return xContentBuilder2;
    }

    @NotNull
    public final Instant component1() {
        return this.lastUpdateTime;
    }

    @NotNull
    public final Instant component2() {
        return this.createdTime;
    }

    @NotNull
    public final List<String> component3() {
        return this.access;
    }

    @NotNull
    public final DocMetadata copy(@NotNull Instant lastUpdateTime, @NotNull Instant createdTime, @NotNull List<String> access) {
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter(access, (String)ACCESS_LIST_TAG);
        return new DocMetadata(lastUpdateTime, createdTime, access);
    }

    public static /* synthetic */ DocMetadata copy$default(DocMetadata docMetadata, Instant instant, Instant instant2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            instant = docMetadata.lastUpdateTime;
        }
        if ((n & 2) != 0) {
            instant2 = docMetadata.createdTime;
        }
        if ((n & 4) != 0) {
            list = docMetadata.access;
        }
        return docMetadata.copy(instant, instant2, list);
    }

    @NotNull
    public String toString() {
        return "DocMetadata(lastUpdateTime=" + this.lastUpdateTime + ", createdTime=" + this.createdTime + ", access=" + this.access + ")";
    }

    public int hashCode() {
        int result = this.lastUpdateTime.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + ((Object)this.access).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocMetadata)) {
            return false;
        }
        DocMetadata docMetadata = (DocMetadata)other;
        if (!Intrinsics.areEqual((Object)this.lastUpdateTime, (Object)docMetadata.lastUpdateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)docMetadata.createdTime)) {
            return false;
        }
        return Intrinsics.areEqual(this.access, docMetadata.access);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/notifications/model/DocMetadata$Companion;", "", "()V", "ACCESS_LIST_TAG", "", "METADATA_TAG", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/notifications/model/DocMetadata;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-notifications"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final DocMetadata parse(@NotNull XContentParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Instant lastUpdateTime = null;
            Instant createdTime = null;
            List access = CollectionsKt.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block10: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName;
                block16: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block16;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 786082091: {
                            if (string.equals("last_updated_time_ms")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1513344513: {
                            if (string.equals("created_time_ms")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1423461020: {
                            if (string.equals(DocMetadata.ACCESS_LIST_TAG)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                            continue block10;
                        }
                        case 2: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block10;
                        }
                        case 3: {
                            access = XContentHelpersKt.stringList((XContentParser)parser);
                            continue block10;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("DocMetadata Skipping Unknown field " + fieldName);
            }
            if (lastUpdateTime == null) {
                throw new IllegalArgumentException("last_updated_time_ms field absent");
            }
            if (createdTime == null) {
                throw new IllegalArgumentException("created_time_ms field absent");
            }
            return new DocMetadata(lastUpdateTime, createdTime, access);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

