/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.undeploy;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelNodesRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportUndeployModelsAction
extends HandledTransportAction<ActionRequest, MLUndeployModelsResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUndeployModelsAction.class);
    TransportService transportService;
    ModelHelper modelHelper;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLModelManager mlModelManager;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public TransportUndeployModelsAction(TransportService transportService, ActionFilters actionFilters, ModelHelper modelHelper, MLTaskManager mlTaskManager, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLModelManager mlModelManager, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/undeploy_models", transportService, actionFilters, MLDeployModelRequest::new);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlModelManager = mlModelManager;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelsRequest undeployModelsRequest = MLUndeployModelsRequest.fromActionRequest((ActionRequest)request);
        String[] modelIds = undeployModelsRequest.getModelIds();
        String[] targetNodeIds = undeployModelsRequest.getNodeIds();
        if (this.modelAccessControlHelper.isModelAccessControlEnabled()) {
            if (modelIds == null || modelIds.length != 1) {
                throw new IllegalArgumentException("only support undeploy one model");
            }
            String modelId = modelIds[0];
            this.validateAccess(modelId, (ActionListener<Boolean>)ActionListener.wrap(hasPermissionToUndeploy -> {
                if (hasPermissionToUndeploy.booleanValue()) {
                    MLUndeployModelNodesRequest mlUndeployModelNodesRequest = new MLUndeployModelNodesRequest(targetNodeIds, modelIds);
                    this.client.execute((ActionType)MLUndeployModelAction.INSTANCE, (ActionRequest)mlUndeployModelNodesRequest, ActionListener.wrap(r -> listener.onResponse((Object)new MLUndeployModelsResponse(r)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("No permission to undeploy model " + modelId));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        MLUndeployModelNodesRequest mlUndeployModelNodesRequest = new MLUndeployModelNodesRequest(targetNodeIds, modelIds);
        this.client.execute((ActionType)MLUndeployModelAction.INSTANCE, (ActionRequest)mlUndeployModelNodesRequest, ActionListener.wrap(r -> listener.onResponse((Object)new MLUndeployModelsResponse(r)), arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateAccess(String modelId, ActionListener<Boolean> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)ActionListener.wrap(mlModel -> this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, listener), e -> {
                log.error("Failed to find Model", (Throwable)e);
                listener.onFailure(e);
            }), () -> context.restore()));
        }
        catch (Exception e2) {
            log.error("Failed to undeploy ML model");
            listener.onFailure(e2);
        }
    }
}

