/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class GetAlertsRequest
extends ActionRequest {
    private String detectorId;
    private String logType;
    private Table table;
    private String severityLevel;
    private String alertState;
    public static final String DETECTOR_ID = "detector_id";

    public GetAlertsRequest(String detectorId, String logType, Table table, String severityLevel, String alertState) {
        this.detectorId = detectorId;
        this.logType = logType;
        this.table = table;
        this.severityLevel = severityLevel;
        this.alertState = alertState;
    }

    public GetAlertsRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readOptionalString(), Table.readFrom((StreamInput)sin), sin.readString(), sin.readString());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ((this.detectorId == null || this.detectorId.length() == 0) && this.logType == null) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "At least one of detector type or detector id needs to be passed", DETECTOR_ID), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.logType);
        this.table.writeTo(out);
        out.writeString(this.severityLevel);
        out.writeString(this.alertState);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Table getTable() {
        return this.table;
    }

    public String getSeverityLevel() {
        return this.severityLevel;
    }

    public String getAlertState() {
        return this.alertState;
    }

    public String getLogType() {
        return this.logType;
    }
}

