/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.securityanalytics.action.SearchCustomLogTypeAction;
import org.opensearch.securityanalytics.action.SearchCustomLogTypeRequest;
import org.opensearch.securityanalytics.model.CustomLogType;

public class RestSearchCustomLogTypeAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchCustomLogTypeAction.class);

    public String getName() {
        return "search_custom_log_type_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/logtype/_search"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/logtype/_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/logtype/_search"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(FetchSourceContext.parseFromRestRequest((RestRequest)request));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchSourceBuilder.version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
        SearchCustomLogTypeRequest searchCustomLogTypeRequest = new SearchCustomLogTypeRequest(searchRequest);
        return channel -> client.execute((ActionType)SearchCustomLogTypeAction.INSTANCE, (ActionRequest)searchCustomLogTypeRequest, (ActionListener)new RestSearchCustomLogTypeResponseListener((RestChannel)channel, request));
    }

    static class RestSearchCustomLogTypeResponseListener
    extends RestResponseListener<SearchResponse> {
        private final RestRequest request;

        RestSearchCustomLogTypeResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        public RestResponse buildResponse(SearchResponse response) throws Exception {
            for (SearchHit hit : response.getHits()) {
                Map sourceMap = hit.getSourceAsMap();
                CustomLogType logType = new CustomLogType(sourceMap);
                logType.setId(hit.getId());
                logType.setVersion(hit.getVersion());
                XContentBuilder xcb = logType.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
            }
            return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
        }
    }
}

