/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;

public class SecurityAnalyticsException
extends OpenSearchException {
    private static final Logger log = LogManager.getLogger(SecurityAnalyticsException.class);
    private final String message;
    private final RestStatus status;
    private final Exception ex;

    public SecurityAnalyticsException(String message, RestStatus status, Exception ex) {
        super(message, (Throwable)ex, new Object[0]);
        this.message = message;
        this.status = status;
        this.ex = ex;
    }

    public RestStatus status() {
        return this.status;
    }

    public static OpenSearchException wrap(Exception ex) {
        if (ex instanceof OpenSearchException) {
            return SecurityAnalyticsException.wrap((OpenSearchException)ex);
        }
        log.error("Security Analytics error:", (Throwable)ex);
        String friendlyMsg = "Unknown error";
        RestStatus status = RestStatus.INTERNAL_SERVER_ERROR;
        if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
            friendlyMsg = ex.getMessage();
        }
        return new SecurityAnalyticsException(friendlyMsg, status, new Exception(String.format(Locale.getDefault(), "%s: %s", ex.getClass().getName(), ex.getMessage())));
    }

    public static OpenSearchException wrap(OpenSearchException ex) {
        log.error("Security Analytics error:", (Throwable)ex);
        String friendlyMsg = "Unknown error";
        RestStatus status = ex.status();
        if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
            friendlyMsg = ex.getMessage();
        }
        return new SecurityAnalyticsException(friendlyMsg, status, new Exception(String.format(Locale.getDefault(), "%s: %s", ex.getClass().getName(), ex.getMessage())));
    }

    public static OpenSearchException wrap(List<Exception> ex) {
        try {
            RestStatus status = RestStatus.BAD_REQUEST;
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            for (Exception e : ex) {
                builder.field("error", e.getMessage());
                log.error("Security Analytics error:", (Throwable)e);
            }
            builder.endObject();
            String friendlyMsg = builder.toString();
            return new SecurityAnalyticsException(friendlyMsg, status, new Exception(String.format(Locale.getDefault(), "%s: %s", ex.getClass().getName(), friendlyMsg)));
        }
        catch (IOException e) {
            return SecurityAnalyticsException.wrap(e);
        }
    }
}

