/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.provenance.ModelProvenance;

public abstract class SparseModel<T extends Output<T>>
extends Model<T> {
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> activeFeatures;

    public SparseModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, boolean generatesProbabilities, Map<String, List<String>> activeFeatures) {
        super(name, provenance, featureIDMap, outputIDInfo, generatesProbabilities);
        HashMap tmpActiveFeatures = new HashMap();
        for (Map.Entry<String, List<String>> e : activeFeatures.entrySet()) {
            ArrayList features = new ArrayList(e.getValue());
            Collections.sort(features);
            tmpActiveFeatures.put(e.getKey(), Collections.unmodifiableList(features));
        }
        this.activeFeatures = Collections.unmodifiableMap(tmpActiveFeatures);
    }

    public Map<String, List<String>> getActiveFeatures() {
        return this.activeFeatures;
    }

    @Override
    public SparseModel<T> copy() {
        return (SparseModel)super.copy();
    }
}

