/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.props;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ldaptive.props.PropertyInvoker;
import org.ldaptive.props.PropertyValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyInvoker
implements PropertyInvoker {
    private static final Map<String, Map<String, Method[]>> PROPERTIES_CACHE = new HashMap<String, Map<String, Method[]>>();
    private Class<?> clazz;
    private Map<String, Method[]> properties;

    protected synchronized void initialize(Class<?> c) {
        String cacheKey = c.getName();
        if (PROPERTIES_CACHE.containsKey(cacheKey)) {
            this.properties = PROPERTIES_CACHE.get(cacheKey);
        } else {
            this.properties = new HashMap<String, Method[]>();
            for (Method method : c.getMethods()) {
                Method[] m;
                String pName;
                String mName;
                if (method.isBridge()) continue;
                if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
                    mName = method.getName().substring(3);
                    pName = mName.substring(0, 1).toLowerCase() + mName.substring(1, mName.length());
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        m[1] = method;
                        this.properties.put(pName, m);
                        continue;
                    }
                    this.properties.put(pName, new Method[]{null, method});
                    continue;
                }
                if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                    mName = method.getName().substring(3);
                    pName = mName.substring(0, 1).toLowerCase() + mName.substring(1, mName.length());
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        m[0] = method;
                        this.properties.put(pName, m);
                        continue;
                    }
                    this.properties.put(pName, new Method[]{method, null});
                    continue;
                }
                if (method.getName().startsWith("is") && method.getParameterTypes().length == 0) {
                    mName = method.getName().substring(2);
                    pName = mName.substring(0, 1).toLowerCase() + mName.substring(1, mName.length());
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        if (m[0] != null) continue;
                        m[0] = method;
                        this.properties.put(pName, m);
                        continue;
                    }
                    this.properties.put(pName, new Method[]{method, null});
                    continue;
                }
                if (!"initialize".equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                String pName2 = method.getName();
                this.properties.put(pName2, new Method[]{method, method});
            }
            Iterator<Method[]> i = this.properties.values().iterator();
            while (i.hasNext()) {
                Method[] m = i.next();
                if (m[0] != null && m[1] != null) continue;
                i.remove();
            }
            PROPERTIES_CACHE.put(cacheKey, Collections.unmodifiableMap(this.properties));
        }
        this.clazz = c;
    }

    @Override
    public void setProperty(Object object, String name, String value) {
        Method setter;
        Method getter;
        if (!this.clazz.isInstance(object)) {
            throw new IllegalArgumentException("Illegal attempt to set property for class " + this.clazz.getName() + " on object of type " + object.getClass().getName());
        }
        Method method = getter = this.properties.get(name) != null ? this.properties.get(name)[0] : null;
        if (getter == null) {
            throw new IllegalArgumentException("No getter method found for " + name + " on object " + this.clazz.getName());
        }
        Method method2 = setter = this.properties.get(name) != null ? this.properties.get(name)[1] : null;
        if (setter == null) {
            throw new IllegalArgumentException("No setter method found for " + name + " on object " + this.clazz.getName());
        }
        AbstractPropertyInvoker.invokeMethod(setter, object, this.convertValue(getter.getReturnType(), value));
    }

    protected abstract Object convertValue(Class<?> var1, String var2);

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Set<String> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public static <T> T instantiateType(T type, String className) {
        try {
            try {
                Class<?> clazz = AbstractPropertyInvoker.createClass(className);
                Constructor<?> con = clazz.getDeclaredConstructor(null);
                Object t = con.newInstance(new Object[0]);
                return (T)t;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (RuntimeException e) {
            Logger l = LoggerFactory.getLogger(AbstractPropertyInvoker.class);
            l.error("Error instantiating type {}, with {}", type, (Object)className);
            throw e;
        }
    }

    public static Class<?> createClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find class '%s'", className), e);
        }
    }

    protected Object convertSimpleType(Class<?> type, String value) {
        Object newValue = value;
        if (Class.class.isAssignableFrom(type)) {
            newValue = this.createTypeFromPropertyValue(Class.class, value);
        } else if (Class[].class.isAssignableFrom(type)) {
            newValue = this.createArrayTypeFromPropertyValue(Class.class, value);
        } else if (type.isEnum()) {
            newValue = AbstractPropertyInvoker.getEnum(type, value);
        } else if (String[].class == type) {
            newValue = value.split(",");
        } else if (Object[].class == type) {
            newValue = value.split(",");
        } else if (Float.TYPE == type) {
            newValue = Float.valueOf(Float.parseFloat(value));
        } else if (Integer.TYPE == type) {
            newValue = Integer.parseInt(value);
        } else if (Long.TYPE == type) {
            newValue = Long.parseLong(value);
        } else if (Short.TYPE == type) {
            newValue = Short.parseShort(value);
        } else if (Double.TYPE == type) {
            newValue = Double.parseDouble(value);
        } else if (Boolean.TYPE == type) {
            newValue = Boolean.valueOf(value);
        } else if (Duration.class == type) {
            newValue = Duration.parse(value);
        }
        return newValue;
    }

    protected static Enum<?> getEnum(Class<?> clazz, String value) {
        for (Object o : clazz.getEnumConstants()) {
            Enum e = (Enum)o;
            if (!e.name().equals(value)) continue;
            return e;
        }
        throw new IllegalArgumentException(String.format("Unknown enum value %s for %s", value, clazz));
    }

    protected Object createTypeFromPropertyValue(Class<?> c, String s) {
        Class<?> newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else if (PropertyValueParser.isConfig(s)) {
            PropertyValueParser configParser = new PropertyValueParser(s);
            newObject = configParser.initializeType();
        } else {
            newObject = Class.class == c ? AbstractPropertyInvoker.createClass(s) : AbstractPropertyInvoker.instantiateType(c, s);
        }
        return newObject;
    }

    protected Object createArrayTypeFromPropertyValue(Class<?> c, String s) {
        Object newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else if (s.contains("},")) {
            String[] classes = s.split("\\},");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = classes[i] + "}";
                if (!PropertyValueParser.isConfig(classes[i])) {
                    throw new IllegalArgumentException(String.format("Could not parse property string: %s", classes[i]));
                }
                PropertyValueParser configParser = new PropertyValueParser(classes[i]);
                Array.set(newObject, i, configParser.initializeType());
            }
        } else {
            String[] classes = s.split(",");
            newObject = Array.newInstance(c, classes.length);
            for (int i = 0; i < classes.length; ++i) {
                if (PropertyValueParser.isConfig(classes[i])) {
                    PropertyValueParser configParser = new PropertyValueParser(classes[i]);
                    Array.set(newObject, i, configParser.initializeType());
                    continue;
                }
                if (Class.class == c) {
                    Array.set(newObject, i, AbstractPropertyInvoker.createClass(classes[i]));
                    continue;
                }
                Array.set(newObject, i, AbstractPropertyInvoker.instantiateType(c, classes[i]));
            }
        }
        return newObject;
    }

    protected Object createArrayEnumFromPropertyValue(Class<?> c, String s) {
        Object newObject;
        if ("null".equals(s)) {
            newObject = null;
        } else {
            String[] values = s.split(",");
            newObject = Array.newInstance(c, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(newObject, i, AbstractPropertyInvoker.getEnum(c, values[i]));
            }
        }
        return newObject;
    }

    public static Object invokeMethod(Method method, Object object, Object arg) {
        try {
            try {
                Object[] params = new Object[]{arg};
                if (arg == null && method.getParameterTypes().length == 0) {
                    params = null;
                }
                return method.invoke(object, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (RuntimeException e) {
            Logger l = LoggerFactory.getLogger(AbstractPropertyInvoker.class);
            l.error("Error invoking {}, on {}, with params {}", new Object[]{method, object, arg});
            throw e;
        }
    }
}

