"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBubble = void 0;
var points_1 = require("./points");
function renderBubble(shift, dataSeries, xScale, yScale, color, panel, hasY0Accessors, xScaleOffset, seriesStyle, markSizeOptions, isMixedChart, pointStyleAccessor) {
    var _a = points_1.renderPoints(shift - xScaleOffset, dataSeries, xScale, yScale, panel, color, seriesStyle.point, hasY0Accessors, markSizeOptions, pointStyleAccessor, !isMixedChart), pointGeometries = _a.pointGeometries, indexedGeometryMap = _a.indexedGeometryMap;
    var bubbleGeometry = {
        points: pointGeometries,
        color: color,
        seriesIdentifier: {
            key: dataSeries.key,
            specId: dataSeries.specId,
            yAccessor: dataSeries.yAccessor,
            splitAccessors: dataSeries.splitAccessors,
            seriesKeys: dataSeries.seriesKeys,
            smHorizontalAccessorValue: dataSeries.smHorizontalAccessorValue,
            smVerticalAccessorValue: dataSeries.smVerticalAccessorValue,
        },
        seriesPointStyle: seriesStyle.point,
    };
    return {
        bubbleGeometry: bubbleGeometry,
        indexedGeometryMap: indexedGeometryMap,
    };
}
exports.renderBubble = renderBubble;
//# sourceMappingURL=bubble.js.map