"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;

var _constants = require("../utils/constants");

var _operators = require("rxjs/operators");

var _router = _interopRequireDefault(require("./router"));

var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));

var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));

var _ad = _interopRequireWildcard(require("./routes/ad"));

var _alerting = _interopRequireWildcard(require("./routes/alerting"));

var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));

var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));

var _constants2 = require("./utils/constants");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                   * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                   * compatible open source license.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                   * GitHub history for details.
                                                                                                                                                                                                                   */

class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }

  async setup(core) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch; // Create OpenSearch client w/ relevant plugins and headers

    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      plugins: [_adPlugin.default, _alertingPlugin.default],
      customHeaders: { ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    }); // Create router

    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH); // Create services & register with OpenSearch client

    const adService = new _ad.default(client);
    const alertingService = new _alerting.default(client);
    const opensearchService = new _opensearch.default(client);
    const sampleDataService = new _sampleData.default(client); // Register server routes with the service

    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    return {};
  }

  async start(core) {
    return {};
  }

}

exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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