"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggregations = void 0;

var _lodash = require("lodash");

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class Aggregations extends _node.PPLNode {
  constructor(name, children, partitions, allNum, delim, aggExprList, groupExprList, dedupSplitValue, indices) {
    super(name, children);
    this.partitions = partitions;
    this.allNum = allNum;
    this.delim = delim;
    this.aggExprList = aggExprList;
    this.groupExprList = groupExprList;
    this.dedupSplitValue = dedupSplitValue;
    this.indices = indices;
  }

  getStartEndIndicesOfOriginQuery() {
    if (this.indices === undefined) {
      return {
        start: -1,
        end: -1
      };
    }

    return {
      start: this.indices.start,
      end: this.indices.end
    };
  }

  getTokens() {
    return {
      partitions: this.partitions,
      all_num: this.allNum,
      delim: this.delim,
      aggregations: this.aggExprList.map(aggTerm => aggTerm.getTokens()),
      groupby: !(0, _lodash.isEmpty)(this.groupExprList) ? this.groupExprList.getTokens() : '',
      dedup_split_value: this.dedupSplitValue
    };
  }

  toString() {
    return `stats ${!(0, _lodash.isEmpty)(this.partitions) ? `${this.partitions} ` : ''}${!(0, _lodash.isEmpty)(this.allNum) ? `${this.allNum} ` : ''}${!(0, _lodash.isEmpty)(this.delim) ? `${this.delim} ` : ''}${this.aggExprList.map(aggTerm => aggTerm.toString()).join(', ')}${!(0, _lodash.isEmpty)(this.groupExprList) ? ` ${this.groupExprList.toString()}` : ''}${!(0, _lodash.isEmpty)(this.dedupSplitValue) ? ` ${this.dedupSplitValue}` : ''}`;
  }

}

exports.Aggregations = Aggregations;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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