"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = query;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function query(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_JSON,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLJson(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SPARK_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + "/{id}",
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncGetQuery(request, request.params.id);
    return response.ok({
      body: retVal
    });
  });
  server.delete({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + "/{id}",
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeAsyncDeleteQuery(request, request.params.id);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: _constants.ROUTE_PATH_GET_DATASOURCES,
    validate: {}
  }, async (context, request, response) => {
    const retVal = await service.describeSyncQueryDataSources(request);
    return response.ok({
      body: retVal
    });
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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