"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class AlertService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getAlerts", async (_context, request, response) => {
      try {
        const {
          detectorType,
          detector_id,
          sortOrder,
          size
        } = request.query;
        const defaultParams = {
          sortOrder,
          size
        };
        let params;

        if (detector_id) {
          params = { ...defaultParams,
            detector_id
          };
        } else if (detectorType) {
          params = { ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.GET_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "acknowledgeAlerts", async (_context, request, response) => {
      try {
        const {
          detector_id
        } = request.params;
        const {
          alerts
        } = request.body;
        const body = {
          alerts: alerts
        };
        const params = {
          body,
          detector_id
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const acknowledgeAlertsResponse = await callWithRequest(_constants.CLIENT_ALERTS_METHODS.ACKNOWLEDGE_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: acknowledgeAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - acknowledgeAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Alerts API.
   */

  /**
   * Calls backend POST Acknowledge Alerts API.
   */


}

exports.default = AlertService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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