# Standard librarary imports
from typing import TYPE_CHECKING, ClassVar, Literal

# External imports
if TYPE_CHECKING:
    from typing_extensions import TypeAlias

_ByType: TypeAlias = Literal["class name", "css selector", "id", "link text", "name", "partial link text", "tag name"]

class By:
    CLASS_NAME: ClassVar[Literal["class name"]] = ...
    CSS_SELECTOR: ClassVar[Literal["css selector"]] = ...
    ID: ClassVar[Literal["id"]] = ...
    LINK_TEXT: ClassVar[Literal["link text"]] = ...
    NAME: ClassVar[Literal["name"]] = ...
    PARTIAL_LINK_TEXT: ClassVar[Literal["partial link text"]] = ...
    TAG_NAME: ClassVar[Literal["tag name"]] = ...
