/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.BadVersionException;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.VersionedData;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.impl.PlacementPluginAssignStrategy;
import org.apache.solr.cluster.placement.plugins.AffinityPlacementFactory;
import org.apache.solr.cluster.placement.plugins.MinimizeCoresPlacementFactory;
import org.apache.solr.cluster.placement.plugins.RandomPlacementFactory;
import org.apache.solr.cluster.placement.plugins.SimplePlacementFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.util.NumberUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assign {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SYSTEM_COLL_PREFIX = ".sys.";
    public static final String PLACEMENTPLUGIN_DEFAULT_SYSPROP = "solr.placementplugin.default";

    public static String getCounterNodePath(String collection) {
        return "/collections/" + collection + "/counter";
    }

    public static int incAndGetId(DistribStateManager stateManager, String collection, int defaultValue) {
        String path = "/collections/" + collection;
        try {
            if (!stateManager.hasData(path)) {
                try {
                    stateManager.makePath(path);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
            }
            if (!stateManager.hasData(path = path + "/counter")) {
                try {
                    stateManager.createData(path, NumberUtils.intToBytes(defaultValue), CreateMode.PERSISTENT);
                }
                catch (AlreadyExistsException alreadyExistsException) {}
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, (Throwable)e);
        }
        catch (IOException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, e);
        }
        while (true) {
            try {
                int version = 0;
                int currentId = 0;
                VersionedData data = stateManager.getData(path, null);
                if (data != null) {
                    currentId = NumberUtils.bytesToInt(data.getData());
                    version = data.getVersion();
                }
                byte[] bytes = NumberUtils.intToBytes(++currentId);
                stateManager.setData(path, bytes, version);
                return currentId;
            }
            catch (BadVersionException e) {
                continue;
            }
            catch (IOException | KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, (Throwable)e);
            }
            break;
        }
    }

    public static String assignCoreNodeName(DistribStateManager stateManager, DocCollection collection) {
        int defaultValue = Assign.defaultCounterValue(collection, false);
        String coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        while (collection.getReplica(coreNodeName) != null) {
            coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        }
        return coreNodeName;
    }

    public static String assignShard(DocCollection collection, Integer numShards) {
        Map sliceMap;
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map map = sliceMap = collection != null ? collection.getActiveSlicesMap() : null;
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map2.put(shardId, cnt);
        }
        shardIdNames.sort((o1, o2) -> {
            Integer one = (Integer)map2.get(o1);
            Integer two = (Integer)map2.get(o2);
            return one.compareTo(two);
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    public static String buildSolrCoreName(String collectionName, String shard, Replica.Type type, int replicaNum) {
        return String.format(Locale.ROOT, "%s_%s_replica_%s%s", collectionName, shard, type.name().substring(0, 1).toLowerCase(Locale.ROOT), replicaNum);
    }

    private static int defaultCounterValue(DocCollection collection, boolean newCollection, String shard) {
        if (newCollection || collection == null) {
            return 0;
        }
        if (collection.getSlice(shard) != null && collection.getSlice(shard).getReplicas().isEmpty()) {
            return 0;
        }
        int defaultValue = collection.getReplicas().size() * 2;
        if (collection.getReplicationFactor() != null) {
            defaultValue = Math.max(defaultValue, collection.getReplicationFactor() * collection.getSlices().size());
        }
        return defaultValue;
    }

    private static int defaultCounterValue(DocCollection collection, boolean newCollection) {
        if (newCollection) {
            return 0;
        }
        int defaultValue = collection.getReplicas().size();
        return defaultValue;
    }

    public static String buildSolrCoreName(DistribStateManager stateManager, String collectionName, DocCollection collection, String shard, Replica.Type type, boolean newCollection) {
        int defaultValue = Assign.defaultCounterValue(collection, newCollection, shard);
        int replicaNum = Assign.incAndGetId(stateManager, collectionName, defaultValue);
        String coreName = Assign.buildSolrCoreName(collectionName, shard, type, replicaNum);
        while (collection != null && Assign.existCoreName(coreName, collection.getSlice(shard))) {
            replicaNum = Assign.incAndGetId(stateManager, collectionName, defaultValue);
            coreName = Assign.buildSolrCoreName(collectionName, shard, type, replicaNum);
        }
        return coreName;
    }

    public static String buildSolrCoreName(DistribStateManager stateManager, DocCollection collection, String shard, Replica.Type type) {
        return Assign.buildSolrCoreName(stateManager, collection.getName(), collection, shard, type, false);
    }

    private static boolean existCoreName(String coreName, Slice slice) {
        if (slice == null) {
            return false;
        }
        for (Replica replica : slice.getReplicas()) {
            if (!coreName.equals(replica.getStr("core"))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random, DistribStateManager zk) {
        ArrayList<String> nodeList;
        List createNodeList;
        String createNodeSetStr = message.getStr("createNodeSet");
        List list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart((String)("EMPTY".equals(createNodeSetStr) ? "" : createNodeSetStr), (String)",", (boolean)true));
        if (createNodeList != null) {
            nodeList = new ArrayList(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool("createNodeSet.shuffle", true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(Assign.filterNonDataNodes(zk, liveNodes));
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    public static Collection<String> filterNonDataNodes(DistribStateManager zk, Collection<String> liveNodes) {
        try {
            List<String> noData = ClusterAPI.getNodesByRole(NodeRoles.Role.DATA, "off", zk);
            if (noData.isEmpty()) {
                return liveNodes;
            }
            liveNodes = new HashSet<String>(liveNodes);
            liveNodes.removeAll(noData);
            return liveNodes;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching roles from Zookeeper", (Throwable)e);
        }
    }

    public static List<ReplicaPosition> getNodesForNewReplicas(ClusterState clusterState, String collectionName, String shard, int nrtReplicas, int tlogReplicas, int pullReplicas, Object createNodeSet, SolrCloudManager cloudManager, CoreContainer coreContainer) throws IOException, InterruptedException, AssignmentException {
        log.debug("getNodesForNewReplicas() shard: {} , nrtReplicas : {} , tlogReplicas: {} , pullReplicas: {} , createNodeSet {}", new Object[]{shard, nrtReplicas, tlogReplicas, pullReplicas, createNodeSet});
        List createNodeList = createNodeSet instanceof List ? (List)createNodeSet : (createNodeSet == null ? null : new ArrayList(new LinkedHashSet(StrUtils.splitSmart((String)((String)createNodeSet), (String)",", (boolean)true))));
        Assign.checkLiveNodes(createNodeList, clusterState);
        AssignRequest assignRequest = new AssignRequestBuilder().forCollection(collectionName).forShard(Collections.singletonList(shard)).assignNrtReplicas(nrtReplicas).assignTlogReplicas(tlogReplicas).assignPullReplicas(pullReplicas).onNodes(createNodeList).build();
        AssignStrategy assignStrategy = Assign.createAssignStrategy(coreContainer);
        return assignStrategy.assign(cloudManager, assignRequest);
    }

    private static List<String> checkLiveNodes(List<String> createNodeList, ClusterState clusterState) {
        Set liveNodes = clusterState.getLiveNodes();
        if (createNodeList != null && !liveNodes.containsAll(createNodeList)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of the node(s) specified " + createNodeList + " are not currently active in " + liveNodes + ", no action taken.");
        }
        return createNodeList;
    }

    public static AssignStrategy createAssignStrategy(CoreContainer coreContainer) {
        PlacementPlugin placementPlugin = coreContainer.getPlacementPluginFactory().createPluginInstance();
        if (placementPlugin == null) {
            String defaultPluginId = System.getProperty(PLACEMENTPLUGIN_DEFAULT_SYSPROP);
            if (defaultPluginId != null) {
                switch (defaultPluginId.toLowerCase(Locale.ROOT)) {
                    case "simple": {
                        placementPlugin = new SimplePlacementFactory().createPluginInstance();
                        break;
                    }
                    case "affinity": {
                        placementPlugin = new AffinityPlacementFactory().createPluginInstance();
                        break;
                    }
                    case "minimizecores": {
                        placementPlugin = new MinimizeCoresPlacementFactory().createPluginInstance();
                        break;
                    }
                    case "random": {
                        placementPlugin = new RandomPlacementFactory().createPluginInstance();
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid value for system property 'solr.placementplugin.default'. Supported values are 'simple', 'random', 'affinity' and 'minimizecores'");
                    }
                }
                log.info("Default replica placement plugin set in {} to {}", (Object)PLACEMENTPLUGIN_DEFAULT_SYSPROP, (Object)defaultPluginId);
            } else {
                placementPlugin = new SimplePlacementFactory().createPluginInstance();
            }
        }
        return new PlacementPluginAssignStrategy(placementPlugin);
    }

    public static class AssignRequestBuilder {
        private String collectionName;
        private List<String> shardNames;
        private List<String> nodes;
        private int numNrtReplicas;
        private int numTlogReplicas;
        private int numPullReplicas;

        public AssignRequestBuilder forCollection(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public AssignRequestBuilder forShard(List<String> shardNames) {
            this.shardNames = shardNames;
            return this;
        }

        public AssignRequestBuilder onNodes(List<String> nodes) {
            this.nodes = nodes;
            return this;
        }

        public AssignRequestBuilder assignNrtReplicas(int numNrtReplicas) {
            this.numNrtReplicas = numNrtReplicas;
            return this;
        }

        public AssignRequestBuilder assignTlogReplicas(int numTlogReplicas) {
            this.numTlogReplicas = numTlogReplicas;
            return this;
        }

        public AssignRequestBuilder assignPullReplicas(int numPullReplicas) {
            this.numPullReplicas = numPullReplicas;
            return this;
        }

        public AssignRequest build() {
            Objects.requireNonNull(this.collectionName, "The collectionName cannot be null");
            Objects.requireNonNull(this.shardNames, "The shard names cannot be null");
            return new AssignRequest(this.collectionName, this.shardNames, this.nodes, this.numNrtReplicas, this.numTlogReplicas, this.numPullReplicas);
        }
    }

    public static class AssignRequest {
        public final String collectionName;
        public final List<String> shardNames;
        public final List<String> nodes;
        public final int numNrtReplicas;
        public final int numTlogReplicas;
        public final int numPullReplicas;

        public AssignRequest(String collectionName, List<String> shardNames, List<String> nodes, int numNrtReplicas, int numTlogReplicas, int numPullReplicas) {
            this.collectionName = collectionName;
            this.shardNames = shardNames;
            this.nodes = nodes;
            this.numNrtReplicas = numNrtReplicas;
            this.numTlogReplicas = numTlogReplicas;
            this.numPullReplicas = numPullReplicas;
        }
    }

    public static interface AssignStrategy {
        default public List<ReplicaPosition> assign(SolrCloudManager solrCloudManager, AssignRequest ... assignRequests) throws AssignmentException, IOException, InterruptedException {
            return this.assign(solrCloudManager, Arrays.asList(assignRequests));
        }

        public List<ReplicaPosition> assign(SolrCloudManager var1, List<AssignRequest> var2) throws AssignmentException, IOException, InterruptedException;

        default public void verifyDeleteCollection(SolrCloudManager solrCloudManager, DocCollection collection) throws AssignmentException, IOException, InterruptedException {
        }

        default public void verifyDeleteReplicas(SolrCloudManager solrCloudManager, DocCollection collection, String shardName, Set<Replica> replicas) throws AssignmentException, IOException, InterruptedException {
        }
    }

    public static class AssignmentException
    extends RuntimeException {
        public AssignmentException() {
        }

        public AssignmentException(String message) {
            super(message);
        }

        public AssignmentException(String message, Throwable cause) {
            super(message, cause);
        }

        public AssignmentException(Throwable cause) {
            super(cause);
        }

        public AssignmentException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

