/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;

public class MacroExpander {
    public static final String MACRO_START = "${";
    private static final int MAX_LEVELS = 25;
    private Map<String, String[]> orig;
    private Map<String, String[]> expanded;
    private String macroStart = "${";
    private char escape = (char)92;
    private int level;
    private final boolean failOnMissingParams;

    public MacroExpander(Map<String, String[]> orig) {
        this(orig, false);
    }

    public MacroExpander(Map<String, String[]> orig, boolean failOnMissingParams) {
        this.orig = orig;
        this.failOnMissingParams = failOnMissingParams;
    }

    public static Map<String, String[]> expand(Map<String, String[]> params) {
        MacroExpander mc = new MacroExpander(params);
        mc.expand();
        return mc.expanded;
    }

    public boolean expand() {
        this.expanded = new HashMap<String, String[]>(this.orig.size());
        boolean changed = false;
        for (Map.Entry<String, String[]> entry : this.orig.entrySet()) {
            String k = entry.getKey();
            String[] values = entry.getValue();
            if (!this.isExpandingExpr().booleanValue() && "expr".equals(k)) {
                this.expanded.put(k, values);
                continue;
            }
            String newK = this.expand(k);
            ArrayList<String> newValues = null;
            for (String v : values) {
                String newV = this.expand(v);
                if (!Objects.equals(newV, v) && newValues == null) {
                    newValues = new ArrayList<String>(values.length);
                    for (String vv : values) {
                        if (Objects.equals(vv, v)) break;
                        newValues.add(vv);
                    }
                }
                if (newValues == null) continue;
                newValues.add(newV);
            }
            if (newValues != null) {
                values = newValues.toArray(new String[0]);
                changed = true;
            }
            if (!Objects.equals(k, newK)) {
                changed = true;
            }
            this.expanded.put(newK, values);
        }
        return changed;
    }

    private Boolean isExpandingExpr() {
        return Boolean.valueOf(System.getProperty("StreamingExpressionMacros", "false"));
    }

    public String expand(String val) {
        ++this.level;
        try {
            if (this.level >= 25) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request template exceeded max nesting of 25 expanding '" + val + "'");
            }
            String string = this._expand(val);
            return string;
        }
        finally {
            --this.level;
        }
    }

    private String _expand(String val) {
        int idx = val.indexOf(this.macroStart.charAt(0));
        if (idx < 0) {
            return val;
        }
        int start = 0;
        StringBuilder sb = null;
        while (true) {
            int matchedStart;
            int rbrace;
            assert (idx >= start);
            if ((idx = val.indexOf(this.macroStart, idx)) > 0) {
                char ch = val.charAt(idx - 1);
                if (ch == this.escape) {
                    idx += this.macroStart.length();
                    continue;
                }
            } else if (idx < 0) break;
            if ((rbrace = val.indexOf(125, (matchedStart = idx) + this.macroStart.length())) == -1) {
                if (!this.failOnMissingParams) break;
                return null;
            }
            if (sb == null) {
                sb = new StringBuilder(val.length() * 2);
            }
            if (matchedStart > 0) {
                sb.append(val, start, matchedStart);
            }
            idx = start = rbrace + 1;
            StrParser parser = new StrParser(val, matchedStart + this.macroStart.length(), rbrace);
            try {
                String[] replacementList;
                String replacement;
                String paramName = parser.getId();
                String defVal = null;
                boolean hasDefault = parser.opt(':');
                if (hasDefault) {
                    defVal = val.substring(parser.pos, rbrace);
                }
                String string = replacement = (replacementList = this.orig.get(paramName)) != null ? replacementList[0] : defVal;
                if (replacement != null) {
                    String expandedReplacement = this.expand(replacement);
                    if (this.failOnMissingParams && expandedReplacement == null) {
                        return null;
                    }
                    sb.append(expandedReplacement);
                    continue;
                }
                if (!this.failOnMissingParams) continue;
                return null;
            }
            catch (SyntaxError syntaxError) {
                if (this.failOnMissingParams) {
                    return null;
                }
                sb.append(val, matchedStart, start);
                continue;
            }
            break;
        }
        if (sb == null) {
            return val;
        }
        sb.append(val, start, val.length());
        return sb.toString();
    }
}

