/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueBool;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.uninverting.UninvertingReader;

public class BoolField
extends PrimitiveFieldType {
    public static final char[] TRUE_TOKEN = new char[]{'T'};
    public static final char[] FALSE_TOKEN = new char[]{'F'};
    protected static final Analyzer boolAnalyzer = new SolrAnalyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            Tokenizer tokenizer = new Tokenizer(){
                final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                boolean done = false;

                public void reset() throws IOException {
                    super.reset();
                    this.done = false;
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    if (this.done) {
                        return false;
                    }
                    this.done = true;
                    int ch = this.input.read();
                    if (ch == -1) {
                        return false;
                    }
                    this.termAtt.copyBuffer(ch == 116 || ch == 84 || ch == 49 ? TRUE_TOKEN : FALSE_TOKEN, 0, 1);
                    return true;
                }
            };
            return new Analyzer.TokenStreamComponents(tokenizer);
        }
    };
    private static final CharsRef TRUE = new CharsRef("true");
    private static final CharsRef FALSE = new CharsRef("false");

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return this.getStringSort(field, reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.SORTED;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new BoolFieldSource(field.name);
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public String toInternal(String val) {
        int ch = val != null && val.length() > 0 ? (int)val.charAt(0) : 0;
        return ch == 49 || ch == 116 || ch == 84 ? "T" : "F";
    }

    @Override
    public String toExternal(IndexableField f) {
        if (null != f.binaryValue()) {
            return this.indexedToReadable(f.binaryValue().utf8ToString());
        }
        if (null != f.stringValue()) {
            return this.indexedToReadable(f.stringValue());
        }
        return null;
    }

    @Override
    public Boolean toObject(IndexableField f) {
        return Boolean.valueOf(this.toExternal(f));
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.bytes[term.offset] == 84;
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        char ch = indexedForm.charAt(0);
        return ch == 'T' ? "true" : "false";
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRefBuilder charsRef) {
        if (input.length > 0 && input.bytes[input.offset] == 84) {
            charsRef.copyChars(TRUE);
        } else {
            charsRef.copyChars(FALSE);
        }
        return charsRef.get();
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeBool(name, this.toObject(f));
    }

    @Override
    public Object marshalSortValue(Object value) {
        return BoolField.marshalStringSortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return BoolField.unmarshalStringSortValue(value);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value) {
        IndexableField fval = this.createField(field, value);
        if (field.hasDocValues()) {
            BytesRef bytes = new BytesRef((CharSequence)this.toInternal(value.toString()));
            Object docval = field.multiValued() ? new SortedSetDocValuesField(field.getName(), bytes) : new SortedDocValuesField(field.getName(), bytes);
            if (fval != null) {
                ArrayList<IndexableField> fields = new ArrayList<IndexableField>(2);
                fields.add(fval);
                fields.add((IndexableField)docval);
                return fields;
            }
            fval = docval;
        }
        return Collections.singletonList(fval);
    }

    @Override
    public Object toNativeType(Object val) {
        if (val instanceof CharSequence) {
            return Boolean.valueOf(val.toString());
        }
        return super.toNativeType(val);
    }

    private static class BoolFieldSource
    extends ValueSource {
        protected String field;
        private static final int hcode = OrdFieldSource.class.hashCode();

        public BoolFieldSource(String field) {
            this.field = field;
        }

        public String description() {
            return "bool(" + this.field + ")";
        }

        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            final SortedDocValues sindex = DocValues.getSorted((LeafReader)readerContext.reader(), (String)this.field);
            int nord = sindex.getValueCount();
            int tord = -2;
            for (int i = 0; i < nord; ++i) {
                BytesRef br = sindex.lookupOrd(i);
                if (br.length != 1 || br.bytes[br.offset] != 84) continue;
                tord = i;
                break;
            }
            final int trueOrd = tord;
            return new BoolDocValues(this){

                private int getOrdForDoc(int doc) throws IOException {
                    if (doc > sindex.docID()) {
                        sindex.advance(doc);
                    }
                    if (doc == sindex.docID()) {
                        return sindex.ordValue();
                    }
                    return -1;
                }

                public boolean boolVal(int doc) throws IOException {
                    return this.getOrdForDoc(doc) == trueOrd;
                }

                public boolean exists(int doc) throws IOException {
                    return this.getOrdForDoc(doc) != -1;
                }

                public FunctionValues.ValueFiller getValueFiller() {
                    return new FunctionValues.ValueFiller(){
                        private final MutableValueBool mval = new MutableValueBool();

                        public MutableValue getValue() {
                            return this.mval;
                        }

                        public void fillValue(int doc) throws IOException {
                            int ord = this.getOrdForDoc(doc);
                            this.mval.value = ord == trueOrd;
                            this.mval.exists = ord != -1;
                        }
                    };
                }
            };
        }

        public boolean equals(Object o) {
            return o instanceof BoolFieldSource && this.field.equals(((BoolFieldSource)((Object)o)).field);
        }

        public int hashCode() {
            return hcode + this.field.hashCode();
        }
    }
}

