/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.PublicKeyHandler;
import org.apache.solr.util.CryptoKeys;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIAuthenticationPlugin
extends AuthenticationPlugin
implements HttpClientBuilderPlugin {
    public static final String ACCEPT_VERSIONS = "solr.pki.acceptVersions";
    public static final String SEND_VERSION = "solr.pki.sendVersion";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MIN_TIMESTAMP_DIGITS = 10;
    private static final int MAX_TIMESTAMP_DIGITS = 13;
    private final Map<String, PublicKey> keyCache = new ConcurrentHashMap<String, PublicKey>();
    private final PublicKeyHandler publicKeyHandler;
    private final CoreContainer cores;
    private static final int MAX_VALIDITY = Integer.getInteger("pkiauth.ttl", 5000);
    private final String myNodeName;
    private final HttpHeaderClientInterceptor interceptor = new HttpHeaderClientInterceptor();
    private boolean interceptorRegistered = false;
    private boolean acceptPkiV1 = false;
    public static final String HEADER = "SolrAuth";
    public static final String HEADER_V2 = "SolrAuthV2";
    public static final String NODE_IS_USER = "$";
    private static final Principal SU = new BasicUserPrincipal("$");

    public static void withServerIdentity(boolean enabled) {
        SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
        if (requestInfo != null) {
            requestInfo.setUseServerToken(enabled);
        }
        ExecutorUtil.setServerThreadFlag((Boolean)(enabled ? Boolean.valueOf(enabled) : null));
    }

    public boolean isInterceptorRegistered() {
        return this.interceptorRegistered;
    }

    public PKIAuthenticationPlugin(CoreContainer cores, String nodeName, PublicKeyHandler publicKeyHandler) {
        String[] versions;
        this.publicKeyHandler = publicKeyHandler;
        this.cores = cores;
        this.myNodeName = nodeName;
        Set<String> knownPkiVersions = Set.of("v1", "v2");
        for (String version : versions = System.getProperty(ACCEPT_VERSIONS, "v2").split(",")) {
            if (!knownPkiVersions.contains(version)) {
                log.warn("Unknown protocol version [{}] specified in {}", (Object)version, (Object)ACCEPT_VERSIONS);
            }
            if (!"v1".equals(version)) continue;
            log.warn("System setting {} includes the deprecated v1, which should only be used for compatibility during rolling upgrades. After all servers have been upgraded, consider disabling this compatability layer.", (Object)ACCEPT_VERSIONS);
            this.acceptPkiV1 = true;
        }
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
    }

    @Override
    @SuppressForbidden(reason="Needs currentTimeMillis to compare against time in header")
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long receivedTime = System.currentTimeMillis();
        String requestURI = request.getRequestURI();
        if (requestURI.endsWith("/admin/info/key")) {
            assert (false) : "Should already be handled by SolrDispatchFilter.authenticateRequest";
            this.numPassThrough.inc();
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        PKIHeaderData headerData = null;
        String headerV2 = request.getHeader(HEADER_V2);
        String headerV1 = request.getHeader(HEADER);
        if (headerV2 != null) {
            int nodeNameEnd = headerV2.indexOf(32);
            if (nodeNameEnd <= 0) {
                return this.sendError(response, true, "Could not parse node name from SolrAuthV2 header.");
            }
            headerData = this.decipherHeaderV2(headerV2, headerV2.substring(0, nodeNameEnd));
        } else if (headerV1 != null && this.acceptPkiV1) {
            List authInfo = StrUtils.splitWS((String)headerV1, (boolean)false);
            if (authInfo.size() != 2) {
                return this.sendError(response, false, "Invalid SolrAuth header: " + headerV1);
            }
            headerData = this.decipherHeader((String)authInfo.get(0), (String)authInfo.get(1));
        }
        if (headerData == null) {
            return this.sendError(response, true, "Could not load principal from SolrAuthV2 header.");
        }
        long elapsed = receivedTime - headerData.timestamp;
        if (elapsed > (long)MAX_VALIDITY) {
            return this.sendError(response, true, "Expired key request timestamp, elapsed=" + elapsed);
        }
        Principal principal = NODE_IS_USER.equals(headerData.userName) ? SU : new BasicUserPrincipal(headerData.userName);
        this.numAuthenticated.inc();
        filterChain.doFilter((ServletRequest)this.wrapWithPrincipal(request, principal), (ServletResponse)response);
        return true;
    }

    private boolean sendError(HttpServletResponse response, boolean v2, String message) throws IOException {
        this.numErrors.mark();
        log.error(message);
        response.setHeader("WWW-Authenticate", v2 ? HEADER_V2 : HEADER);
        response.sendError(401, message);
        return false;
    }

    private PKIHeaderData decipherHeaderV2(String header, String nodeName) {
        byte[] sig;
        int sigStart;
        String data;
        PKIHeaderData rv;
        PublicKey key = this.keyCache.get(nodeName);
        if (key == null) {
            log.debug("No key available for node: {} fetching now ", (Object)nodeName);
            key = this.getRemotePublicKey(nodeName);
            log.debug("public key obtained {} ", (Object)key);
        }
        if ((rv = this.validateSignature(data = header.substring(0, sigStart = header.lastIndexOf(32)), sig = Base64.getDecoder().decode(header.substring(sigStart + 1)), key, false)) == null) {
            log.warn("Failed to verify signature, trying after refreshing the key ");
            key = this.getRemotePublicKey(nodeName);
            rv = this.validateSignature(data, sig, key, true);
        }
        return rv;
    }

    private PKIHeaderData validateSignature(String data, byte[] sig, PublicKey key, boolean isRetry) {
        try {
            if (CryptoKeys.verifySha256(data.getBytes(StandardCharsets.UTF_8), sig, key)) {
                int timestampStart = data.lastIndexOf(32);
                PKIHeaderData rv = new PKIHeaderData();
                String ts = data.substring(timestampStart + 1);
                try {
                    rv.timestamp = Long.parseLong(ts);
                }
                catch (NumberFormatException e) {
                    log.error("SolrAuthV2 header error, cannot parse {} as timestamp", (Object)ts);
                    return null;
                }
                rv.userName = data.substring(data.indexOf(32) + 1, timestampStart);
                return rv;
            }
            log.warn("Signature verification failed, signature or checksum does not match");
            return null;
        }
        catch (InvalidKeyException | SignatureException e) {
            if (isRetry) {
                log.error("Signature validation on retry failed, likely key error");
            } else {
                log.info("Signature validation failed first attempt, likely key error");
            }
            return null;
        }
    }

    private PKIHeaderData decipherHeader(String nodeName, String cipherBase64) {
        PKIHeaderData header;
        PublicKey key = this.keyCache.get(nodeName);
        if (key == null) {
            log.debug("No key available for node: {} fetching now ", (Object)nodeName);
            key = this.getRemotePublicKey(nodeName);
            log.debug("public key obtained {} ", (Object)key);
        }
        if ((header = PKIAuthenticationPlugin.parseCipher(cipherBase64, key, false)) == null) {
            log.warn("Failed to decrypt header, trying after refreshing the key ");
            key = this.getRemotePublicKey(nodeName);
            return PKIAuthenticationPlugin.parseCipher(cipherBase64, key, true);
        }
        return header;
    }

    @VisibleForTesting
    static PKIHeaderData parseCipher(String cipher, PublicKey key, boolean isRetry) {
        byte[] bytes;
        try {
            bytes = CryptoKeys.decryptRSA(Base64.getDecoder().decode(cipher), key);
        }
        catch (Exception e) {
            if (isRetry) {
                log.error("Decryption failed on retry, key must be wrong", (Throwable)e);
            } else {
                log.info("Decryption failed on first attempt, will retry", (Throwable)e);
            }
            return null;
        }
        String s = new String(bytes, StandardCharsets.UTF_8).trim();
        int splitPoint = s.lastIndexOf(32);
        int timestampDigits = s.length() - 1 - splitPoint;
        if (splitPoint == -1 || timestampDigits < 10 || timestampDigits > 13) {
            log.warn("Invalid cipher {} deciphered data {}", (Object)cipher, (Object)s);
            return null;
        }
        PKIHeaderData headerData = new PKIHeaderData();
        try {
            headerData.timestamp = Long.parseLong(s.substring(splitPoint + 1));
            headerData.userName = s.substring(0, splitPoint);
            log.debug("Successfully decrypted header {} {}", (Object)headerData.userName, (Object)headerData.timestamp);
            return headerData;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid cipher {}", (Object)cipher);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublicKey getRemotePublicKey(String nodename) {
        PublicKey publicKey;
        if (!this.cores.getZkController().getZkStateReader().getClusterState().getLiveNodes().contains(nodename)) {
            return null;
        }
        String url = this.cores.getZkController().getZkStateReader().getBaseUrlForNodeName(nodename);
        HttpEntity entity = null;
        try {
            String uri = url + "/admin/info/key?wt=json&omitHeader=true";
            log.debug("Fetching fresh public key from: {}", (Object)uri);
            HttpResponse rsp = this.cores.getUpdateShardHandler().getDefaultHttpClient().execute((HttpUriRequest)new HttpGet(uri), (HttpContext)HttpClientUtil.createNewHttpClientRequestContext());
            entity = rsp.getEntity();
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            Map m = (Map)Utils.fromJSON((byte[])bytes);
            String key = (String)m.get("key");
            if (key == null) {
                log.error("No key available from {}{}", (Object)url, (Object)"/admin/info/key");
                PublicKey publicKey2 = null;
                Utils.consumeFully((HttpEntity)entity);
                return publicKey2;
            }
            log.info("New key obtained from node={}, key={}", (Object)nodename, (Object)key);
            PublicKey pubKey = CryptoKeys.deserializeX509PublicKey(key);
            this.keyCache.put(nodename, pubKey);
            publicKey = pubKey;
            Utils.consumeFully((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("Exception trying to get public key from: {}", (Object)url, (Object)e);
            PublicKey publicKey3 = null;
            return publicKey3;
        }
        finally {
            Utils.consumeFully(entity);
        }
        return publicKey;
    }

    @Override
    public void setup(Http2SolrClient client) {
        HttpListenerFactory.RequestResponseListener listener = new HttpListenerFactory.RequestResponseListener(){

            public void onQueued(Request request) {
                log.trace("onQueued: {}", (Object)request);
                if (PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin() == null) {
                    log.trace("no authentication plugin, skipping");
                    return;
                }
                if (!PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().interceptInternodeRequest(request)) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} secures this internode request", (Object)((Object)((Object)this)).getClass().getSimpleName());
                    }
                    if ("v1".equals(System.getProperty(PKIAuthenticationPlugin.SEND_VERSION))) {
                        PKIAuthenticationPlugin.this.generateToken().ifPresent(s -> request.header(PKIAuthenticationPlugin.HEADER, s));
                    } else {
                        PKIAuthenticationPlugin.this.generateTokenV2().ifPresent(s -> request.header(PKIAuthenticationPlugin.HEADER_V2, s));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("{} secures this internode request", (Object)PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().getClass().getSimpleName());
                }
            }
        };
        client.addListenerFactory(() -> listener);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(SolrHttpClientBuilder builder) {
        HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)this.interceptor);
        this.interceptorRegistered = true;
        return builder;
    }

    public boolean needsAuthorization(HttpServletRequest req) {
        return req.getUserPrincipal() != SU;
    }

    private String getUser() {
        SolrRequestInfo reqInfo = this.getRequestInfo();
        if (reqInfo != null && !reqInfo.useServerToken()) {
            Principal principal = reqInfo.getUserPrincipal();
            if (principal == null) {
                log.debug("generateToken: principal is null");
                return null;
            }
            assert (principal.getName() != null);
            return principal.getName();
        }
        if (!this.isSolrThread()) {
            log.debug("generateToken: not a solr (server) thread");
            return null;
        }
        return NODE_IS_USER;
    }

    @SuppressForbidden(reason="Needs currentTimeMillis to set current time in header")
    private Optional<String> generateToken() {
        String usr = this.getUser();
        if (usr == null) {
            return Optional.empty();
        }
        String s = usr + " " + System.currentTimeMillis();
        byte[] payload = s.getBytes(StandardCharsets.UTF_8);
        byte[] payloadCipher = this.publicKeyHandler.getKeyPair().encrypt(ByteBuffer.wrap(payload));
        String base64Cipher = Base64.getEncoder().encodeToString(payloadCipher);
        log.trace("generateToken: usr={} token={}", (Object)usr, (Object)base64Cipher);
        return Optional.of(this.myNodeName + " " + base64Cipher);
    }

    private Optional<String> generateTokenV2() {
        String user = this.getUser();
        if (user == null) {
            return Optional.empty();
        }
        String s = this.myNodeName + " " + user + " " + Instant.now().toEpochMilli();
        byte[] payload = s.getBytes(StandardCharsets.UTF_8);
        byte[] signature = this.publicKeyHandler.getKeyPair().signSha256(payload);
        String base64Signature = Base64.getEncoder().encodeToString(signature);
        return Optional.of(s + " " + base64Signature);
    }

    void setHeader(HttpRequest httpRequest) {
        if ("v1".equals(System.getProperty(SEND_VERSION))) {
            this.generateToken().ifPresent(s -> httpRequest.setHeader(HEADER, s));
        } else {
            this.generateTokenV2().ifPresent(s -> httpRequest.setHeader(HEADER_V2, s));
        }
    }

    boolean isSolrThread() {
        return ExecutorUtil.isSolrServerThread();
    }

    SolrRequestInfo getRequestInfo() {
        return SolrRequestInfo.getRequestInfo();
    }

    @Override
    public void close() throws IOException {
        HttpClientUtil.removeRequestInterceptor((HttpRequestInterceptor)this.interceptor);
        this.interceptorRegistered = false;
    }

    @VisibleForTesting
    public String getPublicKey() {
        return this.publicKeyHandler.getKeyPair().getPublicKeyStr();
    }

    private class HttpHeaderClientInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            if (PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin() == null) {
                return;
            }
            if (!PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().interceptInternodeRequest(httpRequest, httpContext)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} secures this internode request", (Object)this.getClass().getSimpleName());
                }
                PKIAuthenticationPlugin.this.setHeader(httpRequest);
            } else if (log.isDebugEnabled()) {
                log.debug("{} secures this internode request", (Object)PKIAuthenticationPlugin.this.cores.getAuthenticationPlugin().getClass().getSimpleName());
            }
        }
    }

    public static class PKIHeaderData {
        String userName;
        long timestamp;

        public String toString() {
            return "PKIHeaderData{userName='" + this.userName + "', timestamp=" + this.timestamp + "}";
        }
    }
}

