/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.geocoder.Geocoder;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@ChannelHandler.Sharable
public class GeocoderHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocoderHandler.class);
    private final Geocoder geocoder;
    private final CacheManager cacheManager;
    private final boolean ignorePositions;
    private final boolean processInvalidPositions;
    private final int reuseDistance;

    public GeocoderHandler(Config config, Geocoder geocoder, CacheManager cacheManager) {
        this.geocoder = geocoder;
        this.cacheManager = cacheManager;
        this.ignorePositions = config.getBoolean(Keys.GEOCODER_IGNORE_POSITIONS);
        this.processInvalidPositions = config.getBoolean(Keys.GEOCODER_PROCESS_INVALID_POSITIONS);
        this.reuseDistance = config.getInteger(Keys.GEOCODER_REUSE_DISTANCE, 0);
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) {
        if (message instanceof Position && !this.ignorePositions) {
            final Position position = (Position)message;
            if (this.processInvalidPositions || position.getValid()) {
                Position lastPosition;
                if (this.reuseDistance != 0 && (lastPosition = this.cacheManager.getPosition(position.getDeviceId())) != null && lastPosition.getAddress() != null && position.getDouble("distance") <= (double)this.reuseDistance) {
                    position.setAddress(lastPosition.getAddress());
                    ctx.fireChannelRead((Object)position);
                    return;
                }
                this.geocoder.getAddress(position.getLatitude(), position.getLongitude(), new Geocoder.ReverseGeocoderCallback(){

                    @Override
                    public void onSuccess(String address) {
                        position.setAddress(address);
                        ctx.fireChannelRead((Object)position);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        LOGGER.warn("Geocoding failed", e);
                        ctx.fireChannelRead((Object)position);
                    }
                });
            } else {
                ctx.fireChannelRead((Object)position);
            }
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

