/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.mail.MailManager;
import org.traccar.model.Device;
import org.traccar.model.Disableable;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.notification.TextTemplateFormatter;
import org.traccar.schedule.ScheduleTask;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class TaskExpirations
implements ScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExpirations.class);
    private static final long CHECK_PERIOD_HOURS = 1L;
    private final Config config;
    private final Storage storage;
    private final TextTemplateFormatter textTemplateFormatter;
    private final MailManager mailManager;

    @Inject
    public TaskExpirations(Config config, Storage storage, TextTemplateFormatter textTemplateFormatter, MailManager mailManager) {
        this.config = config;
        this.storage = storage;
        this.textTemplateFormatter = textTemplateFormatter;
        this.mailManager = mailManager;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.HOURS);
    }

    private boolean checkTimeTrigger(Disableable disableable, long currentTime, long offsetTime) {
        if (disableable.getExpirationTime() != null) {
            long expirationTime;
            long previousTime = currentTime - TimeUnit.HOURS.toMillis(1L);
            return previousTime < (expirationTime = disableable.getExpirationTime().getTime() + offsetTime) && currentTime >= expirationTime;
        }
        return false;
    }

    private void sendUserExpiration(Server server, User user, String template) throws MessagingException {
        VelocityContext velocityContext = this.textTemplateFormatter.prepareContext(server, user);
        velocityContext.put("expiration", (Object)user.getExpirationTime());
        NotificationMessage fullMessage = this.textTemplateFormatter.formatMessage(velocityContext, template, "full");
        this.mailManager.sendMessage(user, true, fullMessage.getSubject(), fullMessage.getBody());
    }

    private void sendDeviceExpiration(Server server, Device device, String template) throws MessagingException, StorageException {
        List<User> users = this.storage.getObjects(User.class, new Request((Columns)new Columns.All(), new Condition.Permission(User.class, Device.class, device.getId())));
        for (User user : users) {
            VelocityContext velocityContext = this.textTemplateFormatter.prepareContext(server, user);
            velocityContext.put("expiration", (Object)device.getExpirationTime());
            velocityContext.put("device", (Object)device);
            NotificationMessage fullMessage = this.textTemplateFormatter.formatMessage(velocityContext, template, "full");
            this.mailManager.sendMessage(user, true, fullMessage.getSubject(), fullMessage.getBody());
        }
    }

    @Override
    public void run() {
        try {
            long reminder;
            long currentTime = System.currentTimeMillis();
            Server server = this.storage.getObject(Server.class, new Request(new Columns.All()));
            if (this.config.getBoolean(Keys.NOTIFICATION_EXPIRATION_USER)) {
                reminder = this.config.getLong(Keys.NOTIFICATION_EXPIRATION_USER_REMINDER);
                List<User> users = this.storage.getObjects(User.class, new Request(new Columns.All()));
                for (User user : users) {
                    if (this.checkTimeTrigger(user, currentTime, 0L)) {
                        this.sendUserExpiration(server, user, "userExpiration");
                        continue;
                    }
                    if (reminder <= 0L || !this.checkTimeTrigger(user, currentTime, -reminder)) continue;
                    this.sendUserExpiration(server, user, "userExpirationReminder");
                }
            }
            if (this.config.getBoolean(Keys.NOTIFICATION_EXPIRATION_DEVICE)) {
                reminder = this.config.getLong(Keys.NOTIFICATION_EXPIRATION_USER_REMINDER);
                List<Device> devices = this.storage.getObjects(Device.class, new Request(new Columns.All()));
                for (Device device : devices) {
                    if (this.checkTimeTrigger(device, currentTime, 0L)) {
                        this.sendDeviceExpiration(server, device, "deviceExpiration");
                        continue;
                    }
                    if (reminder <= 0L || !this.checkTimeTrigger(device, currentTime, -reminder)) continue;
                    this.sendDeviceExpiration(server, device, "deviceExpirationReminder");
                }
            }
        }
        catch (MessagingException | StorageException e) {
            LOGGER.warn("Failed to check expirations", e);
        }
    }
}

