/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.function.Function;
import org.jparsec.InternalFunctors;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Token;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Checks;
import org.jparsec.internal.util.Strings;

class Lexicon {
    final Function<String, Object> words;
    final Parser<?> tokenizer;

    Lexicon(Function<String, Object> words, Parser<?> tokenizer) {
        this.words = words;
        this.tokenizer = tokenizer;
    }

    public Parser<?> tokenizer() {
        return this.tokenizer;
    }

    public Parser<?> phrase(String ... tokenNames) {
        Parser[] wordParsers = new Parser[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
            wordParsers[i] = this.token(tokenNames[i]);
        }
        String phrase = Strings.join(" ", tokenNames);
        return Parsers.sequence(wordParsers).atomic().retn(phrase).label(phrase);
    }

    public Parser<Token> token(String ... tokenNames) {
        if (tokenNames.length == 0) {
            return Parsers.never();
        }
        Parser[] ps = new Parser[tokenNames.length];
        for (int i = 0; i < tokenNames.length; ++i) {
            ps[i] = Parsers.token(InternalFunctors.tokenWithSameValue(this.word(tokenNames[i])));
        }
        return Parsers.or(ps);
    }

    public Parser<Token> token(String tokenName) {
        return Parsers.token(InternalFunctors.tokenWithSameValue(this.word(tokenName)));
    }

    @Private
    Object word(String name) {
        Object p = this.words.apply(name);
        Checks.checkArgument(p != null, "token %s unavailable", name);
        return p;
    }

    Lexicon union(Lexicon that) {
        return new Lexicon(Lexicon.fallback(this.words, that.words), Parsers.or(this.tokenizer, that.tokenizer));
    }

    static <F, T> Function<F, T> fallback(Function<F, T> function, Function<? super F, ? extends T> defaultFunction) {
        return from -> {
            Object result = function.apply(from);
            return result == null ? defaultFunction.apply((Object)from) : result;
        };
    }
}

