/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.core.MissingDataChangeGenerator;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Data;
import liquibase.util.ISODateFormat;
import liquibase.util.JdbcUtil;
import liquibase.util.csv.CSVWriter;

@LiquibaseService(skip=true)
public class MissingDataExternalFileChangeGenerator
extends MissingDataChangeGenerator {
    private final String dataDir;

    public MissingDataExternalFileChangeGenerator(String dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Data.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl outputControl, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        block54: {
            block53: {
                block49: {
                    block50: {
                        rs = null;
                        stmt = ((JdbcConnection)referenceDatabase.getConnection()).createStatement(1003, 1007);
                        data = (Data)missingObject;
                        table = data.getTable();
                        if (!referenceDatabase.isLiquibaseObject(table)) break block49;
                        var10_13 = null;
                        if (stmt == null) break block50;
                        stmt.close();
                    }
                    return var10_13;
                }
                sql = "SELECT * FROM " + referenceDatabase.escapeTableName(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName());
                stmt.setFetchSize(100);
                rs = stmt.executeQuery(sql);
                if (!rs.isBeforeFirst()) ** break block51
                columnNames = new ArrayList<String>();
                for (i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    columnNames.add(rs.getMetaData().getColumnName(i + 1));
                }
                pathHandlerFactory = Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
                fileName = table.getName().toLowerCase() + ".csv";
                externalFileResource = pathHandlerFactory.getResource(fileName);
                if (this.dataDir != null) {
                    dataDirResource = pathHandlerFactory.getResource(this.dataDir);
                    externalFileResource = dataDirResource.resolve(fileName);
                }
                dataTypes = new String[]{};
                fileOutputStream = externalFileResource.openOutputStream(new OpenOptions());
                try {
                    outputStreamWriter = new OutputStreamWriter(fileOutputStream, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
                    try {
                        outputFile = new CSVWriter(new BufferedWriter(outputStreamWriter));
                        try {
                            dataTypes = new String[columnNames.size()];
                            line = new String[columnNames.size()];
                            for (i = 0; i < columnNames.size(); ++i) {
                                line[i] = (String)columnNames.get(i);
                            }
                            outputFile.writeNext(line);
                            rowNum = 0;
                            while (rs.next()) {
                                line = new String[columnNames.size()];
                                for (i = 0; i < columnNames.size(); ++i) {
                                    value = JdbcUtil.getResultSetValue(rs, i + 1);
                                    if (dataTypes[i] == null && value != null) {
                                        dataTypes[i] = value instanceof Number != false ? "NUMERIC" : (value instanceof Boolean != false ? "BOOLEAN" : (value instanceof Date != false ? "DATE" : (value instanceof byte[] != false ? "BLOB" : "STRING")));
                                    }
                                    line[i] = value == null ? "NULL" : (value instanceof Date != false ? new ISODateFormat().format((Date)value) : (value instanceof byte[] != false ? Base64.getEncoder().encodeToString((byte[])value) : value.toString()));
                                }
                                outputFile.writeNext(line);
                                if (++rowNum % 5000 != 0) continue;
                                outputFile.flush();
                            }
                        }
                        finally {
                            outputFile.close();
                        }
                    }
                    finally {
                        outputStreamWriter.close();
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                change = new LoadDataChange();
                change.setFile(externalFileResource.getPath());
                change.setEncoding(GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
                if (outputControl.getIncludeCatalog()) {
                    change.setCatalogName(table.getSchema().getCatalogName());
                }
                if (outputControl.getIncludeSchema()) {
                    change.setSchemaName(table.getSchema().getName());
                }
                change.setTableName(table.getName());
                for (i = 0; i < columnNames.size(); ++i) {
                    colName = (String)columnNames.get(i);
                    columnConfig = new LoadDataColumnConfig();
                    columnConfig.setHeader(colName);
                    columnConfig.setName(colName);
                    columnConfig.setType(dataTypes[i] != null ? dataTypes[i] : "skip");
                    change.addColumn(columnConfig);
                }
                var17_28 = new Change[]{change};
                if (stmt == null) break block53;
                stmt.close();
            }
            return var17_28;
            {
                var11_17 = Change.EMPTY_CHANGE;
                if (stmt == null) break block54;
                stmt.close();
            }
        }
        return var11_17;
        {
            catch (Throwable var8_10) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable var9_12) {
                            var8_10.addSuppressed(var9_12);
                        }
                    }
                    throw var8_10;
                }
                catch (Exception e) {
                    throw new UnexpectedLiquibaseException(e);
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException var11_15) {}
            }
        }
    }
}

