/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TmgProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$").expression("(...),").expression("[LH],").optional().number("(d+),").number("(dd)(dd)(dddd),").number("(dd)(dd)(dd),").number("(d),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.?d*),").number("(d+.?d*),").groupBegin().number("(-?d+.?d*),").number("(d+.d+),").number("(d+),").number("(d+),").number("([^,]*),").number("(d+),").number("[^,]*,").expression("([01]),").number("(d+.?d*),").number("(d+.?d*),").expression("([01]+),").expression("([01]+),").expression("[01]+,").number("(d+.?d*)[^,]*,").number("(d+.?d*)[^,]*,").number("d+.?d*,").expression("([^,]*),").expression("([^,]*),").optional().or().number("[^,]*,").number("(d+),").number("(d+),").number("[^,]*,").expression("([01]),").expression("([LH]{4}),").expression("[NT]{4},").expression("([LH]{2}),").number("(d+.d+),").number("(d+.d+),").number("[^,]*,").number("(d+),").groupEnd().any().compile();

    public TmgProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        String type = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        switch (type) {
            case "rmv": {
                position.set("alarm", "powerCut");
                break;
            }
            case "ebl": {
                position.set("alarm", "lowPower");
                break;
            }
            case "ibl": {
                position.set("alarm", "lowBattery");
                break;
            }
            case "tmp": 
            case "smt": 
            case "btt": {
                position.set("alarm", "tampering");
                break;
            }
            case "ion": {
                position.set("ignition", true);
                break;
            }
            case "iof": {
                position.set("ignition", false);
                break;
            }
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.nextInt() > 0);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        if (parser.hasNext(15)) {
            position.setAltitude(parser.nextDouble());
            position.set("hdop", parser.nextDouble());
            position.set("sat", parser.nextInt());
            position.set("satVisible", parser.nextInt());
            position.set("operator", parser.next());
            position.set("rssi", parser.nextInt());
            position.set("ignition", parser.nextInt() == 1);
            position.set("battery", parser.nextDouble());
            position.set("power", parser.nextDouble());
            int input = parser.nextBinInt();
            int output = parser.nextBinInt();
            if (!BitUtil.check(input, 0)) {
                position.set("alarm", "sos");
            }
            position.set("input", input);
            position.set("output", output);
            position.set("adc1", parser.nextDouble());
            position.set("adc2", parser.nextDouble());
            position.set("versionFw", parser.next());
            position.set("driverUniqueId", parser.next());
        }
        if (parser.hasNext(6)) {
            position.set("rssi", parser.nextInt());
            position.set("sat", parser.nextInt());
            position.set("ignition", parser.nextInt() == 1);
            char[] input = parser.next().toCharArray();
            for (int i = 0; i < input.length; ++i) {
                position.set("in" + (i + 1), input[i] == 'H');
            }
            char[] output = parser.next().toCharArray();
            for (int i = 0; i < output.length; ++i) {
                position.set("out" + (i + 1), output[i] == 'H');
            }
            position.set("adc1", parser.nextDouble());
            position.set("adc2", parser.nextDouble());
            position.set("odometer", parser.nextInt());
        }
        return position;
    }
}

